/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.iri;

import java.net.URISyntaxException;
import mx.com.hp.hpl.jena.iri.IRIConformanceLevels;
import mx.com.hp.hpl.jena.iri.IRIException;
import mx.com.hp.hpl.jena.iri.RDFURIReference;
import mx.com.hp.hpl.jena.iri.impl.BadIRI;
import mx.com.hp.hpl.jena.iri.impl.EmptyIRI;
import mx.com.hp.hpl.jena.iri.impl.JavaURIWrapper;
import mx.com.hp.hpl.jena.iri.impl.NullIRI;
import mx.com.hp.hpl.jena.iri.impl.XercesURIWrapper;
import mx.com.hp.hpl.jena.rdf.arp.MalformedURIException;
import org.xml.sax.Locator;

public class IRIFactory
implements IRIConformanceLevels {
    final Locator locator;
    static IRIFactory d = new IRIFactory();

    public static IRIFactory defaultFactory() {
        return d;
    }

    public IRIFactory() {
        this(new Locator(){

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }

            public int getLineNumber() {
                return -1;
            }

            public int getColumnNumber() {
                return -1;
            }
        });
    }

    public IRIFactory(Locator l) {
        this.locator = l;
    }

    public RDFURIReference create(String s) {
        if (s == null) {
            return new NullIRI(this);
        }
        if (s.equals("")) {
            return new EmptyIRI(this);
        }
        try {
            return new JavaURIWrapper(this, s);
        }
        catch (URISyntaxException jnue) {
            IRIException irie1 = this.wrapJavaNetException(jnue);
            try {
                return new XercesURIWrapper(irie1, this, s);
            }
            catch (MalformedURIException xue) {
                IRIException irie2 = this.wrapXercesException(xue);
                return new BadIRI(irie1, irie2, this, s);
            }
        }
    }

    public IRIException wrapXercesException(MalformedURIException xue) {
        return new IRIException(21, this, xue);
    }

    public IRIException wrapJavaNetException(URISyntaxException jnue) {
        return new IRIException(0xA | (IRIFactory.isAlsoBadRDFURIRef(jnue) ? 21 : 0), this, jnue);
    }

    private static boolean isAlsoBadRDFURIRef(URISyntaxException jnue) {
        return !jnue.getReason().startsWith("Illegal character");
    }
}

