/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.iri.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import mx.com.hp.hpl.jena.iri.IRIException;
import mx.com.hp.hpl.jena.iri.IRIFactory;
import mx.com.hp.hpl.jena.iri.RDFURIReference;
import mx.com.hp.hpl.jena.iri.impl.JavaURIWrapper;

public abstract class AbsIRI
implements RDFURIReference {
    final IRIFactory factory;
    final AbsIRI parent;
    private int ALL = 31;
    Charset utf8 = Charset.forName("UTF-8");
    private static int[][] prefs = new int[][]{{8, 56}, {16, 48}, {32, 32}};
    static String[] exact = new String[]{".", "..", "../.."};
    static String[] sub = new String[]{"", "../", "../../"};

    public abstract String toString();

    public AbsIRI(IRIFactory f) {
        this.factory = f;
        this.parent = null;
    }

    public AbsIRI(AbsIRI p) {
        this.factory = p.factory;
        this.parent = p;
    }

    public boolean hasException(int conformance) {
        SetFlag setFlag = new SetFlag();
        AbsIRI x = this;
        while (x != null) {
            x.addExceptions(conformance, setFlag);
            if (setFlag.seen) {
                return true;
            }
            x = x.parent;
        }
        return false;
    }

    public boolean isURIinASCII() {
        String str = this.toString();
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch >= '\u0080' || ch <= ' ') {
                return false;
            }
            switch (ch) {
                case '\"': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }

    abstract boolean addExceptions(int var1, Collection var2);

    public Iterator exceptions(int conformance) {
        ArrayList all = new ArrayList();
        AbsIRI x = this;
        while (x != null) {
            x.addExceptions(conformance, all);
            x = x.parent;
        }
        return all.iterator();
    }

    public boolean hasException() {
        return this.hasException(this.ALL);
    }

    public Iterator exceptions() {
        return this.exceptions(this.ALL);
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toString());
    }

    public String toASCIIString() {
        String str = this.toString();
        StringBuffer rslt = new StringBuffer();
        int ln = str.length();
        block3: for (int i = 0; i < ln; ++i) {
            ByteBuffer bytes;
            char ch = str.charAt(i);
            if (ch > ' ' && ch < '\u0080') {
                switch (ch) {
                    case '\"': 
                    case '<': 
                    case '>': 
                    case '\\': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': {
                        break;
                    }
                    default: {
                        rslt.append(ch);
                        continue block3;
                    }
                }
                bytes = ByteBuffer.wrap(new byte[]{(byte)ch});
            } else {
                bytes = this.utf8.encode(str.substring(i, i + 1));
            }
            for (int j = 0; j < bytes.remaining(); ++j) {
                rslt.append('%');
                rslt.append(AbsIRI.toHexDigit(bytes.get(j) / 16));
                rslt.append(AbsIRI.toHexDigit(bytes.get(j) % 16));
            }
        }
        return rslt.toString();
    }

    private static char toHexDigit(int i) {
        return (char)(i < 10 ? 48 + i : 65 + i - 10);
    }

    abstract RDFURIReference resolveAgainst(JavaURIWrapper var1);

    protected void addException(IRIException exception, int level, Collection here) {
        if ((exception.getConformance() & level) != 0) {
            here.add(exception);
        }
    }

    public abstract RDFURIReference reparent(AbsIRI var1);

    public String relativize(String abs, int flags) {
        return this.relativize(this.factory.create(abs), abs, flags);
    }

    public RDFURIReference relativize(RDFURIReference abs, int flags) {
        String rslt = this.relativize(abs, null, flags);
        return rslt == null ? abs : this.factory.create(rslt);
    }

    private String relativize(RDFURIReference r, String def, int flags) {
        String[] m_subPaths;
        String rslt;
        if (r.isOpaque() || r.isVeryBad()) {
            return def;
        }
        boolean net = this.equal(r.getScheme(), this.getScheme());
        boolean absl = net && this.equal(r.getHost(), this.getHost()) && this.equal(this.getUserinfo(), r.getUserinfo()) && this.equal(this.getPort(), r.getPort());
        boolean same = absl && this.equal(this.getPath(), r.getPath()) && this.equal(this.getQuery(), r.getQuery());
        String string = rslt = r.getFragment() == null ? "" : "#" + r.getFragment();
        if (same && (flags & 1) != 0) {
            return rslt;
        }
        if (r.getQuery() != null) {
            rslt = "?" + r.getQuery() + rslt;
        }
        if (absl && (m_subPaths = new String[]{this.getPath() == null ? null : this.getPath() + "a", null, null, null})[0] != null) {
            for (int i = 0; i < 3 && (flags & prefs[i][1]) != 0; ++i) {
                if (m_subPaths[i + 1] == null) {
                    m_subPaths[i + 1] = AbsIRI.getLastSlash(m_subPaths[i]);
                }
                if (m_subPaths[i + 1].length() == 0) break;
                if ((flags & prefs[i][0]) == 0 || !r.getPath().startsWith(m_subPaths[i + 1])) continue;
                int lg = m_subPaths[i + 1].length();
                if (lg == r.getPath().length()) {
                    return exact[i] + rslt;
                }
                rslt = sub[i] + r.getPath().substring(lg) + rslt;
                return rslt;
            }
        }
        rslt = r.getPath() + rslt;
        if (absl && (flags & 4) != 0) {
            return rslt;
        }
        if (net && (flags & 2) != 0) {
            return "//" + (r.getUserinfo() == null ? "" : r.getUserinfo() + "@") + r.getHost() + (r.getPort() == -1 ? "" : ":" + r.getPort()) + rslt;
        }
        return def;
    }

    private static String getLastSlash(String s) {
        int ix = s.lastIndexOf(47, s.length() - 2);
        return s.substring(0, ix + 1);
    }

    private boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private boolean equal(int s1, int s2) {
        return s1 == s2;
    }

    public String getUserinfo() {
        return null;
    }

    public int getPort() {
        return -1;
    }

    public String getPath() {
        return null;
    }

    public String getQuery() {
        return null;
    }

    public String getFragment() {
        return null;
    }

    public String getHost() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    private static class SetFlag
    extends AbstractCollection {
        boolean seen = false;

        private SetFlag() {
        }

        public int size() {
            throw new IllegalStateException("SetFlag is not really a Collection");
        }

        public Iterator iterator() {
            throw new IllegalStateException("SetFlag is not really a Collection");
        }

        public boolean add(Object o) {
            this.seen = true;
            return true;
        }
    }
}

