/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.iri.impl;

import java.net.URISyntaxException;
import java.util.Collection;
import mx.com.hp.hpl.jena.iri.IRIException;
import mx.com.hp.hpl.jena.iri.IRIFactory;
import mx.com.hp.hpl.jena.iri.RDFURIReference;
import mx.com.hp.hpl.jena.iri.impl.AbsIRI;
import mx.com.hp.hpl.jena.iri.impl.JavaURIWrapper;
import mx.com.hp.hpl.jena.iri.impl.XercesURIWrapper;
import mx.com.hp.hpl.jena.rdf.arp.MalformedURIException;

public class BadIRI
extends AbsIRI {
    final String iri;
    final IRIException exception1;
    final IRIException exception2;

    public BadIRI(IRIException e1, IRIException e2, IRIFactory f, String s) {
        super(f);
        this.iri = s;
        this.exception1 = e1;
        this.exception2 = e2;
    }

    public BadIRI(IRIException e1, IRIException e2, AbsIRI p, String s) {
        super(p);
        this.iri = s;
        this.exception1 = e1;
        this.exception2 = e2;
    }

    public boolean isAbsolute() {
        return false;
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean isRelative() {
        return false;
    }

    public boolean isRDFURIReference() {
        return false;
    }

    public boolean isIRI() {
        return false;
    }

    public boolean isJavaNetURI() {
        return false;
    }

    public boolean isVeryBad() {
        return true;
    }

    public boolean isXSanyURI() {
        return false;
    }

    public RDFURIReference resolve(RDFURIReference rel) {
        return ((AbsIRI)rel).reparent(this);
    }

    public RDFURIReference resolve(String uri) {
        return ((AbsIRI)this.factory.create(uri)).reparent(this);
    }

    RDFURIReference resolveAgainst(JavaURIWrapper base) {
        try {
            return new JavaURIWrapper((AbsIRI)base, base.iri.resolve(this.iri));
        }
        catch (IllegalArgumentException e) {
            IRIException irie1 = null;
            try {
                irie1 = this.factory.wrapJavaNetException((URISyntaxException)e.getCause());
                return new XercesURIWrapper(irie1, this.factory, base.toString()).resolve(this);
            }
            catch (MalformedURIException mue) {
                return new BadIRI(irie1, this.factory.wrapXercesException(mue), this, this.iri);
            }
        }
    }

    boolean addExceptions(int level, Collection here) {
        this.addException(this.exception1, level, here);
        this.addException(this.exception2, level, here);
        return true;
    }

    public RDFURIReference reparent(AbsIRI badIRI) {
        return new BadIRI(this.exception1, this.exception2, badIRI, this.iri);
    }

    public boolean isURIinASCII() {
        return false;
    }

    public String toString() {
        return this.iri;
    }
}

