/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.iri.impl;

import java.util.Collection;
import mx.com.hp.hpl.jena.iri.IRIException;
import mx.com.hp.hpl.jena.iri.IRIFactory;
import mx.com.hp.hpl.jena.iri.RDFURIReference;
import mx.com.hp.hpl.jena.iri.impl.AbsIRI;
import mx.com.hp.hpl.jena.iri.impl.JavaURIWrapper;

public class EmptyIRI
extends AbsIRI {
    final IRIException exception;

    public EmptyIRI(IRIFactory f) {
        this(f, "The URI \"\" is a same document reference, and is not absolute, and cannot be resolved against.");
    }

    EmptyIRI(IRIFactory f, String msg) {
        super(f);
        this.exception = new IRIException(16, f, msg);
    }

    public EmptyIRI(IRIException e, AbsIRI p) {
        super(p);
        this.exception = e;
    }

    RDFURIReference resolveAgainst(JavaURIWrapper base) {
        if (base.iri.getFragment() == null) {
            return base;
        }
        String uri = base.toString();
        int hash = uri.indexOf(35);
        if (hash == -1) {
            throw new IllegalArgumentException("Shouldn't happen.");
        }
        return ((AbsIRI)this.factory.create(uri.substring(0, hash))).reparent(base);
    }

    public boolean isAbsolute() {
        return false;
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean isRelative() {
        return true;
    }

    public boolean isRDFURIReference() {
        return false;
    }

    public boolean isIRI() {
        return true;
    }

    public boolean isJavaNetURI() {
        return true;
    }

    public boolean isVeryBad() {
        return false;
    }

    public boolean isXSanyURI() {
        return true;
    }

    public RDFURIReference resolve(RDFURIReference rel) {
        return rel.isRelative() ? ((AbsIRI)rel).reparent(this) : rel;
    }

    public RDFURIReference resolve(String uri) {
        return this.resolve(this.factory.create(uri));
    }

    boolean addExceptions(int level, Collection here) {
        this.addException(this.exception, level, here);
        return true;
    }

    public RDFURIReference reparent(AbsIRI p) {
        return new EmptyIRI(this.exception, p);
    }

    public String toString() {
        return "";
    }
}

