/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.iri.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import mx.com.hp.hpl.jena.iri.IRIFactory;
import mx.com.hp.hpl.jena.iri.RDFURIReference;
import mx.com.hp.hpl.jena.iri.impl.AbsIRI;

public class JavaURIWrapper
extends AbsIRI {
    final URI iri;
    final JavaURIWrapper forResolution;

    public JavaURIWrapper(IRIFactory f, String s) throws URISyntaxException {
        this(f, new URI(s));
    }

    public JavaURIWrapper(AbsIRI p, String s) throws URISyntaxException {
        this(p, new URI(s));
    }

    public JavaURIWrapper(IRIFactory f, URI uri) {
        super(f);
        this.iri = uri;
        this.forResolution = this.nullPathBugWorkaround();
    }

    public JavaURIWrapper(AbsIRI p, URI uri) {
        super(p);
        this.iri = uri;
        this.forResolution = this.nullPathBugWorkaround();
    }

    JavaURIWrapper nullPathBugWorkaround() {
        try {
            return !(this.iri.getRawPath() != null && !this.iri.getRawPath().equals("") || this.iri.toString().endsWith("/") || this.iri.isOpaque()) ? (this.parent != null ? new JavaURIWrapper(this.parent, this.iri.toString() + "/") : new JavaURIWrapper(this.factory, this.iri.toString() + "/")) : this;
        }
        catch (URISyntaxException e) {
            IllegalStateException ise = new IllegalStateException("Shouldn't be possible.");
            ise.initCause(e);
            throw ise;
        }
    }

    public boolean isAbsolute() {
        return this.iri.isAbsolute();
    }

    public boolean isOpaque() {
        return this.iri.isOpaque();
    }

    public boolean isRelative() {
        return !this.iri.isAbsolute();
    }

    public boolean isRDFURIReference() {
        return this.isAbsolute();
    }

    public boolean isIRI() {
        return true;
    }

    public boolean isJavaNetURI() {
        return true;
    }

    public boolean isVeryBad() {
        return false;
    }

    public boolean isXSanyURI() {
        return true;
    }

    public RDFURIReference resolve(RDFURIReference rel) {
        return ((AbsIRI)rel).resolveAgainst(rel.getPath() == null || rel.getPath().equals("") ? this : this.forResolution);
    }

    public RDFURIReference resolve(String uri) {
        return this.resolve(this.factory.create(uri));
    }

    RDFURIReference resolveAgainst(JavaURIWrapper base) {
        return this.isAbsolute() ? this : (base.isOpaque() && this.iri.getRawSchemeSpecificPart().equals("") ? this.factory.create(base.toString() + this.iri.toString()) : (base.isAbsolute() ? new JavaURIWrapper(this.factory, base.iri.resolve(this.iri)) : new JavaURIWrapper((AbsIRI)base, base.iri.resolve(this.iri))));
    }

    boolean addExceptions(int level, Collection here) {
        return (level & 0x10) != 0 && !this.isAbsolute();
    }

    public RDFURIReference reparent(AbsIRI p) {
        return new JavaURIWrapper(p, this.iri);
    }

    public String getUserinfo() {
        return this.iri.getRawUserInfo();
    }

    public int getPort() {
        return this.iri.getPort();
    }

    public String getPath() {
        return this.iri.getRawPath();
    }

    public String getQuery() {
        return this.iri.getRawQuery();
    }

    public String getFragment() {
        return this.iri.getRawFragment();
    }

    public String getHost() {
        return this.iri.getHost();
    }

    public String getScheme() {
        return this.iri.getScheme();
    }

    public String toString() {
        return this.iri.toString();
    }
}

