/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.iri.impl;

import java.io.Serializable;
import mx.com.hp.hpl.jena.rdf.arp.MalformedURIException;
import mx.com.hp.hpl.jena.rdf.arp.impl.CharacterModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XercesURI
implements Serializable {
    static Log logger = LogFactory.getLog((Class)XercesURI.class);
    private static final String RESERVED_CHARACTERS = ";/?:@&=+$,[]";
    private static final String SCHEME_CHARACTERS = "+-.";
    private static final String USERINFO_CHARACTERS = ";:&=+$,";
    private String m_scheme = null;
    private String m_userinfo = null;
    private String m_host = null;
    private String m_port = null;
    private int n_port = -1;
    private String m_path = null;
    private String[] m_subPaths = null;
    private String m_queryString = null;
    private String m_fragment = null;
    private boolean haveCheckedNFC = false;
    private boolean isNFC;
    public static final int SAMEDOCUMENT = 1;
    public static final int NETWORK = 2;
    public static final int ABSOLUTE = 4;
    public static final int RELATIVE = 8;
    public static final int PARENT = 16;
    public static final int GRANDPARENT = 32;
    private static int[][] prefs = new int[][]{{8, 56}, {16, 48}, {32, 32}};
    static String[] exact = new String[]{".", "..", "../.."};
    static String[] sub = new String[]{"", "../", "../../"};

    public XercesURI() {
    }

    public XercesURI(XercesURI p_other) {
        this.initialize(p_other);
    }

    public XercesURI(String p_uriSpec) throws MalformedURIException {
        this((XercesURI)null, p_uriSpec);
    }

    public XercesURI(XercesURI p_base, String p_uriSpec) throws MalformedURIException {
        this.initialize(p_base, p_uriSpec);
    }

    public XercesURI(String p_scheme, String p_schemeSpecificPart) throws MalformedURIException {
        if (p_scheme == null || p_scheme.length() == 0) {
            throw new MalformedURIException("Cannot construct XercesURI with null/empty scheme!");
        }
        if (p_schemeSpecificPart == null || p_schemeSpecificPart.length() == 0) {
            throw new MalformedURIException("Cannot construct XercesURI with null/empty scheme-specific part!");
        }
        this.setScheme(p_scheme);
        this.setPath(p_schemeSpecificPart);
    }

    public XercesURI(String p_scheme, String p_host, String p_path, String p_queryString, String p_fragment) throws MalformedURIException {
        this(p_scheme, null, p_host, -1, p_path, p_queryString, p_fragment);
    }

    public XercesURI(String p_scheme, String p_userinfo, String p_host, int p_port, String p_path, String p_queryString, String p_fragment) throws MalformedURIException {
        if (p_scheme == null || p_scheme.length() == 0) {
            throw new MalformedURIException("Scheme is required!");
        }
        if (p_host == null) {
            if (p_userinfo != null) {
                throw new MalformedURIException("Userinfo may not be specified if host is not specified!");
            }
            if (p_port != -1) {
                throw new MalformedURIException("Port may not be specified if host is not specified!");
            }
        }
        if (p_path != null) {
            if (p_path.indexOf(63) != -1 && p_queryString != null) {
                throw new MalformedURIException("Query string cannot be specified in path and query string!");
            }
            if (p_path.indexOf(35) != -1 && p_fragment != null) {
                throw new MalformedURIException("Fragment cannot be specified in both the path and fragment!");
            }
        }
        this.setScheme(p_scheme);
        this.setHost(p_host);
        this.setPort(p_port);
        this.m_port = "" + p_port;
        this.setUserinfo(p_userinfo);
        this.setPath(p_path);
        this.setQueryString(p_queryString);
        this.setFragment(p_fragment);
    }

    private void initialize(XercesURI p_other) {
        this.m_scheme = p_other.getScheme();
        this.m_userinfo = p_other.getUserinfo();
        this.m_host = p_other.getHost();
        this.m_port = p_other.m_port;
        this.n_port = p_other.n_port;
        this.m_path = p_other.getPath();
        this.m_queryString = p_other.getQueryString();
        this.m_fragment = p_other.getFragment();
    }

    private void initialize(XercesURI p_base, String p_uriSpec) throws MalformedURIException {
        if (p_base == null && (p_uriSpec == null || p_uriSpec.length() == 0)) {
            throw new MalformedURIException("Cannot initialize XercesURI with empty parameters.");
        }
        if (p_uriSpec == null || p_uriSpec.length() == 0) {
            this.initialize(p_base);
            return;
        }
        String uriSpec = p_uriSpec;
        int uriSpecLen = uriSpec.length();
        int index = 0;
        int colonIdx = uriSpec.indexOf(58);
        int slashIdx = uriSpec.indexOf(47);
        int queryIdx = uriSpec.indexOf(63);
        int fragmentIdx = uriSpec.indexOf(35);
        if (colonIdx < 2 || colonIdx > slashIdx && slashIdx != -1 || colonIdx > queryIdx && queryIdx != -1 || colonIdx > fragmentIdx && fragmentIdx != -1) {
            if (p_base == null) {
                throw new MalformedURIException("No scheme found in XercesURI '" + p_uriSpec + "'");
            }
            if (!p_base.isGenericURI() && fragmentIdx != 0) {
                throw new MalformedURIException("Cannot apply relative XercesURI to an opaque XercesURI");
            }
        } else {
            this.initializeScheme(uriSpec);
            index = this.m_scheme.length() + 1;
        }
        if (index + 1 < uriSpecLen && uriSpec.substring(index).startsWith("//")) {
            int startPos = index += 2;
            char testChar = '\u0000';
            while (index < uriSpecLen && (testChar = uriSpec.charAt(index)) != '/' && testChar != '?' && testChar != '#') {
                ++index;
            }
            if (index > startPos) {
                this.initializeAuthority(uriSpec.substring(startPos, index));
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(uriSpec.substring(index));
        if (p_base != null) {
            int lastSlash;
            if (this.m_path.length() == 0 && this.m_scheme == null && this.m_host == null) {
                this.m_scheme = p_base.getScheme();
                this.m_userinfo = p_base.getUserinfo();
                this.m_host = p_base.getHost();
                this.m_port = p_base.m_port;
                this.n_port = p_base.getPort();
                this.m_path = p_base.getPath();
                if (this.m_queryString == null) {
                    this.m_queryString = p_base.getQueryString();
                }
                return;
            }
            if (this.m_scheme != null) {
                return;
            }
            this.m_scheme = p_base.getScheme();
            if (this.m_host != null) {
                return;
            }
            this.m_userinfo = p_base.getUserinfo();
            this.m_host = p_base.getHost();
            this.m_port = p_base.m_port;
            this.n_port = p_base.getPort();
            if (this.m_path.length() > 0 && this.m_path.startsWith("/")) {
                return;
            }
            String path = "/";
            String basePath = p_base.getPath();
            if (basePath != null && (lastSlash = basePath.lastIndexOf(47)) != -1) {
                path = basePath.substring(0, lastSlash + 1);
            }
            path = path.concat(this.m_path);
            index = -1;
            while ((index = path.indexOf("/./")) != -1) {
                path = path.substring(0, index + 1).concat(path.substring(index + 3));
            }
            if (path.endsWith("/.")) {
                path = path.substring(0, path.length() - 1);
            }
            index = 1;
            int segIndex = -1;
            while ((index = path.indexOf("/../", index)) > 0) {
                segIndex = path.lastIndexOf(47, index - 1);
                if (segIndex != -1 && !path.substring(segIndex + 1, index).equals("..")) {
                    path = path.substring(0, segIndex).concat(path.substring(index + 3));
                    index = segIndex;
                    continue;
                }
                index += 4;
            }
            if (path.endsWith("/..") && (segIndex = path.lastIndexOf(47, (index = path.length() - 3) - 1)) != -1 && !path.substring(segIndex + 1, index).equals("..")) {
                path = path.substring(0, segIndex + 1);
            }
            this.m_path = path;
        }
    }

    private void initializeScheme(String p_uriSpec) throws MalformedURIException {
        int uriSpecLen = p_uriSpec.length();
        int index = p_uriSpec.indexOf(58);
        if (index < 1) {
            throw new MalformedURIException("No scheme found in XercesURI '" + p_uriSpec + "'");
        }
        if (index == uriSpecLen - 1) {
            throw new MalformedURIException("A bare scheme name is not a XercesURI: '" + p_uriSpec + "'");
        }
        this.setScheme(p_uriSpec.substring(0, index));
    }

    private void initializeAuthority(String p_uriSpec) throws MalformedURIException {
        int index;
        int start = 0;
        int end = p_uriSpec.length();
        char testChar = '\u0000';
        String userinfo = null;
        if (p_uriSpec.indexOf(64, start) != -1) {
            for (index = 0; index < end && (testChar = p_uriSpec.charAt(index)) != '@'; ++index) {
            }
            userinfo = p_uriSpec.substring(start, index);
            ++index;
        }
        String host = null;
        start = index;
        while (index < end && (testChar = p_uriSpec.charAt(index)) != ':') {
            ++index;
        }
        host = p_uriSpec.substring(start, index);
        int port = -1;
        if (host.length() > 0 && testChar == ':') {
            start = ++index;
            while (index < end) {
                ++index;
            }
            String portStr = p_uriSpec.substring(start, index);
            if (portStr.length() > 0) {
                for (int i = 0; i < portStr.length(); ++i) {
                    if (XercesURI.isDigit(portStr.charAt(i))) continue;
                    throw new MalformedURIException(portStr + " is invalid. Port should only contain digits!");
                }
                try {
                    port = Integer.parseInt(portStr);
                    this.m_port = portStr;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        this.setHost(host);
        this.setPort(port);
        this.setUserinfo(userinfo);
    }

    private void initializePath(String p_uriSpec) throws MalformedURIException {
        int index;
        if (p_uriSpec == null) {
            throw new MalformedURIException("Cannot initialize path from null string!");
        }
        int start = 0;
        int end = p_uriSpec.length();
        char testChar = '\u0000';
        for (index = 0; index < end && (testChar = p_uriSpec.charAt(index)) != '?' && testChar != '#'; ++index) {
            if (testChar == '%') {
                if (index + 2 < end && XercesURI.isHex(p_uriSpec.charAt(index + 1)) && XercesURI.isHex(p_uriSpec.charAt(index + 2))) continue;
                throw new MalformedURIException("Path contains invalid escape sequence: " + p_uriSpec);
            }
            if (XercesURI.isReservedCharacter(testChar) || XercesURI.isUnreservedCharacter(testChar)) continue;
            throw new MalformedURIException("Path '" + p_uriSpec + "' contains invalid character: " + testChar);
        }
        this.m_path = p_uriSpec.substring(start, index);
        if (testChar == '?') {
            start = ++index;
            while (index < end && (testChar = p_uriSpec.charAt(index)) != '#') {
                if (testChar == '%') {
                    if (index + 2 >= end || !XercesURI.isHex(p_uriSpec.charAt(index + 1)) || !XercesURI.isHex(p_uriSpec.charAt(index + 2))) {
                        throw new MalformedURIException("Query string contains invalid escape sequence in '" + p_uriSpec + "'");
                    }
                } else if (!XercesURI.isReservedCharacter(testChar) && !XercesURI.isUnreservedCharacter(testChar)) {
                    throw new MalformedURIException("Query string contains invalid character '" + testChar + "' in '" + p_uriSpec + "'");
                }
                ++index;
            }
            this.m_queryString = p_uriSpec.substring(start, index);
        }
        if (testChar == '#') {
            start = ++index;
            while (index < end) {
                testChar = p_uriSpec.charAt(index);
                if (testChar == '%') {
                    if (index + 2 >= end || !XercesURI.isHex(p_uriSpec.charAt(index + 1)) || !XercesURI.isHex(p_uriSpec.charAt(index + 2))) {
                        throw new MalformedURIException("Fragment contains invalid escape sequence in '" + p_uriSpec + "'");
                    }
                } else if (!XercesURI.isReservedCharacter(testChar) && !XercesURI.isUnreservedCharacter(testChar)) {
                    throw new MalformedURIException("Fragment contains invalid character '" + testChar + "' in '" + p_uriSpec + "'");
                }
                ++index;
            }
            this.m_fragment = p_uriSpec.substring(start, index);
        }
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer schemespec = new StringBuffer();
        if (this.m_userinfo != null || this.m_host != null || this.m_port != null) {
            schemespec.append("//");
        }
        if (this.m_userinfo != null) {
            schemespec.append(this.m_userinfo);
            schemespec.append('@');
        }
        if (this.m_host != null) {
            schemespec.append(this.m_host);
        }
        if (this.m_port != null) {
            schemespec.append(':');
            schemespec.append(this.m_port);
        }
        if (this.m_path != null) {
            schemespec.append(this.m_path);
        }
        if (this.m_queryString != null) {
            schemespec.append('?');
            schemespec.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            schemespec.append('#');
            schemespec.append(this.m_fragment);
        }
        return schemespec.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.n_port;
    }

    public String getPath(boolean p_includeQueryString, boolean p_includeFragment) {
        StringBuffer pathString = new StringBuffer(this.m_path);
        if (p_includeQueryString && this.m_queryString != null) {
            pathString.append('?');
            pathString.append(this.m_queryString);
        }
        if (p_includeFragment && this.m_fragment != null) {
            pathString.append('#');
            pathString.append(this.m_fragment);
        }
        return pathString.toString();
    }

    public String getPath() {
        return this.m_path;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    private void setScheme(String p_scheme) throws MalformedURIException {
        if (p_scheme == null) {
            throw new MalformedURIException("Cannot set scheme from null string!");
        }
        if (!XercesURI.isConformantSchemeName(p_scheme)) {
            throw new MalformedURIException("The scheme '" + p_scheme + "' is not conformant.");
        }
        this.m_scheme = p_scheme;
    }

    private void setUserinfo(String p_userinfo) throws MalformedURIException {
        if (p_userinfo == null) {
            this.m_userinfo = null;
        } else {
            if (this.m_host == null) {
                throw new MalformedURIException("Userinfo cannot be set when host is null!");
            }
            int end = p_userinfo.length();
            char testChar = '\u0000';
            for (int index = 0; index < end; ++index) {
                testChar = p_userinfo.charAt(index);
                if (testChar == '%') {
                    if (index + 2 < end && XercesURI.isHex(p_userinfo.charAt(index + 1)) && XercesURI.isHex(p_userinfo.charAt(index + 2))) continue;
                    throw new MalformedURIException("Userinfo contains invalid escape sequence!");
                }
                if (XercesURI.isUnreservedCharacter(testChar) || USERINFO_CHARACTERS.indexOf(testChar) != -1) continue;
                throw new MalformedURIException("Userinfo contains invalid character:" + testChar);
            }
        }
        this.m_userinfo = p_userinfo;
    }

    private void setHost(String p_host) throws MalformedURIException {
        if (p_host == null || p_host.length() == 0) {
            this.m_host = p_host;
            this.m_userinfo = null;
            this.m_port = null;
            this.n_port = -1;
        } else if (!XercesURI.isWellFormedAddress(p_host)) {
            throw new MalformedURIException("Host is not a well formed address in '" + p_host + "'");
        }
        this.m_host = p_host;
    }

    private void setPort(int p_port) throws MalformedURIException {
        if (p_port >= 0 && p_port <= 65535) {
            if (this.m_host == null) {
                throw new MalformedURIException("Port cannot be set when host is null!");
            }
        } else if (p_port != -1) {
            throw new MalformedURIException("Invalid port number!");
        }
        this.n_port = p_port;
    }

    private void setPath(String p_path) throws MalformedURIException {
        if (p_path == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(p_path);
        }
    }

    private void setQueryString(String p_queryString) throws MalformedURIException {
        if (p_queryString == null) {
            this.m_queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Query string can only be set for a generic XercesURI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Query string cannot be set when path is null!");
            }
            if (!XercesURI.isURIString(p_queryString)) {
                throw new MalformedURIException("Query string contains invalid character!");
            }
            this.m_queryString = p_queryString;
        }
    }

    public void setFragment(String p_fragment) throws MalformedURIException {
        if (p_fragment == null) {
            this.m_fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Fragment can only be set for a generic XercesURI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Fragment cannot be set when path is null!");
            }
            if (!XercesURI.isURIString(p_fragment)) {
                throw new MalformedURIException("Fragment contains invalid character!");
            }
            this.m_fragment = p_fragment;
        }
    }

    public boolean equals(Object p_test) {
        if (p_test instanceof XercesURI) {
            XercesURI testURI = (XercesURI)p_test;
            if ((this.m_scheme == null && testURI.m_scheme == null || this.m_scheme != null && testURI.m_scheme != null && this.m_scheme.equals(testURI.m_scheme)) && (this.m_userinfo == null && testURI.m_userinfo == null || this.m_userinfo != null && testURI.m_userinfo != null && this.m_userinfo.equals(testURI.m_userinfo)) && (this.m_host == null && testURI.m_host == null || this.m_host != null && testURI.m_host != null && this.m_host.equals(testURI.m_host)) && (this.m_port == null && testURI.m_port == null || this.m_port != null && testURI.m_port != null && this.m_port.equals(testURI.m_port)) && (this.m_path == null && testURI.m_path == null || this.m_path != null && testURI.m_path != null && this.m_path.equals(testURI.m_path)) && (this.m_queryString == null && testURI.m_queryString == null || this.m_queryString != null && testURI.m_queryString != null && this.m_queryString.equals(testURI.m_queryString)) && (this.m_fragment == null && testURI.m_fragment == null || this.m_fragment != null && testURI.m_fragment != null && this.m_fragment.equals(testURI.m_fragment))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getURIString();
    }

    public String getURIString() {
        StringBuffer uriSpecString = new StringBuffer();
        if (this.m_scheme != null) {
            uriSpecString.append(this.m_scheme);
            uriSpecString.append(':');
        }
        uriSpecString.append(this.getSchemeSpecificPart());
        return uriSpecString.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isGenericURI() {
        return this.m_host != null;
    }

    public static boolean isConformantSchemeName(String p_scheme) {
        if (p_scheme == null || p_scheme.length() == 0) {
            return false;
        }
        if (!XercesURI.isAlpha(p_scheme.charAt(0))) {
            return false;
        }
        for (int i = 1; i < p_scheme.length(); ++i) {
            char testChar = p_scheme.charAt(i);
            if (XercesURI.isAlphanum(testChar) || SCHEME_CHARACTERS.indexOf(testChar) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedAddress(String p_address) {
        if (p_address == null) {
            return false;
        }
        String address = p_address;
        int addrLength = address.length();
        if (addrLength == 0 || addrLength > 255) {
            return false;
        }
        if (address.startsWith(".") || address.startsWith("-")) {
            return false;
        }
        int index = address.lastIndexOf(46);
        if (address.endsWith(".")) {
            index = address.substring(0, index).lastIndexOf(46);
        }
        if (index + 1 < addrLength && XercesURI.isDigit(p_address.charAt(index + 1))) {
            int numDots = 0;
            for (int i = 0; i < addrLength; ++i) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!XercesURI.isDigit(address.charAt(i - 1)) || i + 1 < addrLength && !XercesURI.isDigit(address.charAt(i + 1))) {
                        return false;
                    }
                    ++numDots;
                    continue;
                }
                if (XercesURI.isDigit(testChar)) continue;
                return false;
            }
            if (numDots != 3) {
                return false;
            }
        } else {
            for (int i = 0; i < addrLength; ++i) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!XercesURI.isAlphanum(address.charAt(i - 1))) {
                        return false;
                    }
                    if (i + 1 >= addrLength || XercesURI.isAlphanum(address.charAt(i + 1))) continue;
                    return false;
                }
                if (XercesURI.isAlphanum(testChar) || testChar == '-') continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isDigit(char p_char) {
        return p_char >= '0' && p_char <= '9';
    }

    private static boolean isHex(char p_char) {
        return XercesURI.isDigit(p_char) || p_char >= 'a' && p_char <= 'f' || p_char >= 'A' && p_char <= 'F';
    }

    private static boolean isAlpha(char p_char) {
        return p_char >= 'a' && p_char <= 'z' || p_char >= 'A' && p_char <= 'Z';
    }

    private static boolean isAlphanum(char p_char) {
        return XercesURI.isAlpha(p_char) || XercesURI.isDigit(p_char);
    }

    private static boolean isReservedCharacter(char p_char) {
        return RESERVED_CHARACTERS.indexOf(p_char) != -1;
    }

    private static boolean isUnreservedCharacter(char p_char) {
        return !XercesURI.isReservedCharacter(p_char) && "#%[]".indexOf(p_char) == -1;
    }

    public boolean isNormalFormC() {
        if (!this.haveCheckedNFC) {
            this.isNFC = CharacterModel.isNormalFormC(this.toString());
            this.haveCheckedNFC = true;
        }
        return this.isNFC;
    }

    private static boolean isURIString(String p_uric) {
        if (p_uric == null) {
            return false;
        }
        int end = p_uric.length();
        char testChar = '\u0000';
        for (int i = 0; i < end; ++i) {
            testChar = p_uric.charAt(i);
            if (testChar == '%') {
                if (i + 2 >= end || !XercesURI.isHex(p_uric.charAt(i + 1)) || !XercesURI.isHex(p_uric.charAt(i + 2))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (XercesURI.isReservedCharacter(testChar) || XercesURI.isUnreservedCharacter(testChar)) continue;
            return false;
        }
        return true;
    }

    private boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public String relativize(String abs, int flags) throws MalformedURIException {
        XercesURI r = new XercesURI(abs);
        if (r.isGenericURI()) {
            String rslt;
            boolean net = this.equal(r.m_scheme, this.m_scheme);
            boolean absl = net && this.equal(r.m_host, this.m_host) && this.equal(this.m_userinfo, r.m_userinfo) && this.equal(this.m_port, r.m_port);
            boolean same = absl && this.equal(this.m_path, r.m_path) && this.equal(this.m_queryString, r.m_queryString);
            String string = rslt = r.m_fragment == null ? "" : "#" + r.m_fragment;
            if (same && (flags & 1) != 0) {
                return rslt;
            }
            if (r.m_queryString != null) {
                rslt = "?" + r.m_queryString + rslt;
            }
            if (absl) {
                if (this.m_subPaths == null) {
                    this.m_subPaths = new String[]{this.m_path == null ? null : this.m_path + "a", null, null, null};
                }
                if (this.m_subPaths[0] != null) {
                    for (int i = 0; i < 3 && (flags & prefs[i][1]) != 0; ++i) {
                        if (this.m_subPaths[i + 1] == null) {
                            this.m_subPaths[i + 1] = XercesURI.getLastSlash(this.m_subPaths[i]);
                        }
                        if (this.m_subPaths[i + 1].length() == 0) break;
                        if ((flags & prefs[i][0]) == 0 || !r.m_path.startsWith(this.m_subPaths[i + 1])) continue;
                        int lg = this.m_subPaths[i + 1].length();
                        if (lg == r.m_path.length()) {
                            return exact[i] + rslt;
                        }
                        rslt = sub[i] + r.m_path.substring(lg) + rslt;
                        return rslt;
                    }
                }
            }
            rslt = r.m_path + rslt;
            if (absl && (flags & 4) != 0) {
                return rslt;
            }
            if (net && (flags & 2) != 0) {
                return "//" + (r.m_userinfo == null ? "" : r.m_userinfo + "@") + r.m_host + (r.m_port == null ? "" : ":" + r.m_port) + rslt;
            }
        }
        return abs;
    }

    private static String getLastSlash(String s) {
        int ix = s.lastIndexOf(47, s.length() - 2);
        return s.substring(0, ix + 1);
    }
}

