/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.mem;

import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.Domain;
import mx.com.hp.hpl.jena.graph.query.StageElement;
import mx.com.hp.hpl.jena.mem.MatchOrBind;
import mx.com.hp.hpl.jena.mem.TripleBunch;
import mx.com.hp.hpl.jena.shared.BrokenException;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;

public class ArrayBunch
extends TripleBunch {
    protected int size = 0;
    protected Triple[] elements = new Triple[9];

    public boolean containsBySameValueAs(Triple t) {
        for (int i = 0; i < this.size; ++i) {
            if (!t.matches(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Triple t) {
        for (int i = 0; i < this.size; ++i) {
            if (!t.equals(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public void add(Triple t) {
        this.elements[this.size++] = t;
    }

    public void remove(Triple t) {
        for (int i = 0; i < this.size; ++i) {
            if (!t.equals(this.elements[i])) continue;
            this.elements[i] = this.elements[--this.size];
            return;
        }
    }

    public void app(Domain d, StageElement next, MatchOrBind s) {
        for (int i = 0; i < this.size; ++i) {
            if (!s.matches(this.elements[i])) continue;
            next.run(d);
        }
    }

    public ExtendedIterator iterator() {
        return new NiceIterator(){
            protected int i = 0;

            public boolean hasNext() {
                return this.i < ArrayBunch.this.size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new BrokenException("ARGH");
                }
                return ArrayBunch.this.elements[this.i++];
            }

            public void remove() {
                if (this.i == ArrayBunch.this.size) {
                    --ArrayBunch.this.size;
                } else {
                    ArrayBunch.this.elements[--this.i] = ArrayBunch.this.elements[--ArrayBunch.this.size];
                }
            }
        };
    }
}

