/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.mem;

import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.graph.impl.TripleStore;
import mx.com.hp.hpl.jena.graph.query.QueryHandler;
import mx.com.hp.hpl.jena.mem.GraphMemBase;
import mx.com.hp.hpl.jena.mem.GraphMemQueryHandler;
import mx.com.hp.hpl.jena.mem.GraphTripleStore;
import mx.com.hp.hpl.jena.shared.ReificationStyle;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class GraphMem
extends GraphMemBase
implements Graph {
    public GraphTripleStore forTestingOnly_getStore() {
        return (GraphTripleStore)this.store;
    }

    public GraphMem() {
        this(ReificationStyle.Minimal);
    }

    public GraphMem(ReificationStyle style) {
        super(style);
    }

    protected TripleStore createTripleStore() {
        return new GraphTripleStore(this);
    }

    protected void destroy() {
        this.store.close();
    }

    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.store.add(t);
        }
    }

    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.store.delete(t);
        }
    }

    public int graphBaseSize() {
        return this.store.size();
    }

    public QueryHandler queryHandler() {
        if (this.queryHandler == null) {
            this.queryHandler = new GraphMemQueryHandler(this);
        }
        return this.queryHandler;
    }

    public ExtendedIterator graphBaseFind(TripleMatch m) {
        return this.store.find(m.asTriple());
    }

    public boolean graphBaseContains(Triple t) {
        return t.isConcrete() ? this.store.contains(t) : super.graphBaseContains(t);
    }

    public void clear() {
        this.store.clear();
    }
}

