/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.mem;

import java.util.Iterator;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.mem.NodeToTriplesMapBase;
import mx.com.hp.hpl.jena.util.CollectionFactory;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;

public class NodeToTriplesMap
extends NodeToTriplesMapBase {
    public NodeToTriplesMap(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        super(indexField, f2, f3);
    }

    public boolean add(Triple t) {
        Object o = this.getIndexField(t);
        Set s = (Set)this.map.get(o);
        if (s == null) {
            s = CollectionFactory.createHashedSet();
            this.map.put(o, s);
        }
        if (s.add(t)) {
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean remove(Triple t) {
        Object o = this.getIndexField(t);
        Set s = (Set)this.map.get(o);
        if (s == null) {
            return false;
        }
        boolean result = s.remove(t);
        if (result) {
            --this.size;
        }
        if (s.isEmpty()) {
            this.map.remove(o);
        }
        return result;
    }

    public Iterator iterator(Object o) {
        Set s = (Set)this.map.get(o);
        return s == null ? NullIterator.instance : s.iterator();
    }

    public boolean contains(Triple t) {
        Set s = (Set)this.map.get(this.getIndexField(t));
        return s == null ? false : s.contains(t);
    }

    protected static boolean equalsObjectOK(Triple t) {
        Node o = t.getObject();
        return o.isLiteral() ? o.getLiteralDatatype() == null : true;
    }

    public boolean containsBySameValueAs(Triple t) {
        return NodeToTriplesMap.equalsObjectOK(t) ? this.contains(t) : this.slowContains(t);
    }

    protected boolean slowContains(Triple t) {
        Set s = (Set)this.map.get(this.getIndexField(t));
        if (s == null) {
            return false;
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            if (!t.matches((Triple)it.next())) continue;
            return true;
        }
        return false;
    }

    public ExtendedIterator iterateAll(Triple pattern) {
        return this.indexField.filterOn(pattern).and(this.f2.filterOn(pattern)).and(this.f3.filterOn(pattern)).filterKeep(this.iterateAll());
    }

    public ExtendedIterator iterator(Node index, Node n2, Node n32) {
        Set s = (Set)this.map.get(index.getIndexingValue());
        return s == null ? NullIterator.instance : this.f2.filterOn(n2).and(this.f3.filterOn(n32)).filterKeep(s.iterator());
    }

    protected Set get(Object y) {
        return (Set)this.map.get(y);
    }

    public Iterator iteratorForIndexed(Object y) {
        return this.get(y).iterator();
    }
}

