/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.mem;

import java.util.Iterator;
import java.util.Map;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.util.CollectionFactory;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;

public abstract class NodeToTriplesMapBase {
    protected Map map = CollectionFactory.createHashedMap();
    protected int size = 0;
    protected final Triple.Field indexField;
    protected final Triple.Field f2;
    protected final Triple.Field f3;

    public NodeToTriplesMapBase(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        this.indexField = indexField;
        this.f2 = f2;
        this.f3 = f3;
    }

    public abstract boolean add(Triple var1);

    public abstract boolean remove(Triple var1);

    public abstract Iterator iterator(Object var1);

    public abstract boolean contains(Triple var1);

    public abstract boolean containsBySameValueAs(Triple var1);

    public final Iterator domain() {
        return this.map.keySet().iterator();
    }

    protected final Object getIndexField(Triple t) {
        return this.indexField.getField(t).getIndexingValue();
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void removedOneViaIterator() {
        --this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public abstract ExtendedIterator iterator(Node var1, Node var2, Node var3);

    public abstract Iterator iteratorForIndexed(Object var1);

    public ExtendedIterator iterateAll() {
        final Iterator nodes = this.domain();
        return new NiceIterator(){
            private Iterator current = NullIterator.instance;

            public Object next() {
                if (!this.hasNext()) {
                    this.noElements("NodeToTriples iterator");
                }
                return this.current.next();
            }

            public boolean hasNext() {
                while (!this.current.hasNext()) {
                    if (!nodes.hasNext()) {
                        return false;
                    }
                    this.current = NodeToTriplesMapBase.this.iterator(nodes.next());
                }
                return true;
            }

            public void remove() {
                this.current.remove();
            }
        };
    }
}

