/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.mem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.util.CollectionFactory;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;

public abstract class ObjectIterator
extends NiceIterator {
    final Iterator domain;
    final Set seen = CollectionFactory.createHashedSet();
    final List pending = new ArrayList();

    public ObjectIterator(Iterator domain) {
        this.domain = domain;
    }

    protected abstract Iterator iteratorFor(Object var1);

    public boolean hasNext() {
        while (this.pending.isEmpty() && this.domain.hasNext()) {
            this.refillPending();
        }
        return !this.pending.isEmpty();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("FasterTripleStore listObjects next()");
        }
        return this.pending.remove(this.pending.size() - 1);
    }

    protected void refillPending() {
        Object y = this.domain.next();
        if (y instanceof Node) {
            this.pending.add(y);
        } else {
            Iterator z = this.iteratorFor(y);
            while (z.hasNext()) {
                Node object = ((Triple)z.next()).getObject();
                if (!this.seen.add(object)) continue;
                this.pending.add(object);
            }
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("listObjects remove()");
    }
}

