/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.mem;

import java.util.Set;
import mx.com.hp.hpl.jena.graph.BulkUpdateHandler;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.graph.TripleMatchFilter;
import mx.com.hp.hpl.jena.graph.impl.SimpleEventManager;
import mx.com.hp.hpl.jena.graph.impl.TripleStore;
import mx.com.hp.hpl.jena.mem.GraphMemBase;
import mx.com.hp.hpl.jena.mem.GraphMemBulkUpdateHandler;
import mx.com.hp.hpl.jena.shared.ReificationStyle;
import mx.com.hp.hpl.jena.util.CollectionFactory;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class SmallGraphMem
extends GraphMemBase {
    protected Set triples = CollectionFactory.createHashedSet();

    public SmallGraphMem() {
        this(ReificationStyle.Minimal);
    }

    public SmallGraphMem(ReificationStyle style) {
        super(style);
    }

    protected TripleStore createTripleStore() {
        return null;
    }

    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.triples.add(t);
        }
    }

    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.triples.remove(t);
        }
    }

    public int graphBaseSize() {
        return this.triples.size();
    }

    public boolean graphBaseContains(Triple t) {
        return t.isConcrete() ? this.triples.contains(t) : this.containsByFind(t);
    }

    protected void destroy() {
        this.triples = null;
    }

    public void clear() {
        this.triples.clear();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new GraphMemBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    public ExtendedIterator graphBaseFind(TripleMatch m) {
        return SimpleEventManager.notifyingRemove(this, this.triples.iterator()).filterKeep(new TripleMatchFilter(m.asTriple()));
    }
}

