/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.mem.faster;

import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.impl.TripleStore;
import mx.com.hp.hpl.jena.graph.query.Applyer;
import mx.com.hp.hpl.jena.graph.query.Domain;
import mx.com.hp.hpl.jena.graph.query.Matcher;
import mx.com.hp.hpl.jena.graph.query.QueryNode;
import mx.com.hp.hpl.jena.graph.query.QueryTriple;
import mx.com.hp.hpl.jena.graph.query.StageElement;
import mx.com.hp.hpl.jena.mem.GraphTripleStoreBase;
import mx.com.hp.hpl.jena.mem.faster.NodeToTriplesMapFaster;
import mx.com.hp.hpl.jena.mem.faster.ProcessedTriple;

public class FasterTripleStore
extends GraphTripleStoreBase
implements TripleStore {
    public FasterTripleStore(Graph parent) {
        super(parent, new NodeToTriplesMapFaster(Triple.Field.getSubject, Triple.Field.getPredicate, Triple.Field.getObject), new NodeToTriplesMapFaster(Triple.Field.getPredicate, Triple.Field.getObject, Triple.Field.getSubject), new NodeToTriplesMapFaster(Triple.Field.getObject, Triple.Field.getSubject, Triple.Field.getPredicate));
    }

    protected NodeToTriplesMapFaster getSubjects() {
        return (NodeToTriplesMapFaster)this.subjects;
    }

    protected NodeToTriplesMapFaster getObjects() {
        return (NodeToTriplesMapFaster)this.objects;
    }

    public Applyer createApplyer(ProcessedTriple pt) {
        if (pt.hasNoVariables()) {
            return this.containsApplyer(pt);
        }
        if (pt.S instanceof QueryNode.Fixed) {
            return this.getSubjects().createFixedSApplyer(pt);
        }
        if (pt.O instanceof QueryNode.Fixed) {
            return this.getObjects().createFixedOApplyer(pt);
        }
        if (pt.S instanceof QueryNode.Bound) {
            return this.getSubjects().createBoundSApplyer(pt);
        }
        if (pt.O instanceof QueryNode.Bound) {
            return this.getObjects().createBoundOApplyer(pt);
        }
        return this.varSvarOApplyer(pt);
    }

    protected Applyer containsApplyer(final ProcessedTriple pt) {
        return new Applyer(){

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                Triple t = new Triple(pt.S.finder(d), pt.P.finder(d), pt.O.finder(d));
                if (FasterTripleStore.this.objects.containsBySameValueAs(t)) {
                    next.run(d);
                }
            }
        };
    }

    protected Applyer varSvarOApplyer(final QueryTriple pt) {
        return new Applyer(){
            protected final QueryNode p;
            {
                this.p = pt.P;
            }

            public Iterator find(Domain d) {
                Node P = this.p.finder(d);
                if (P.isConcrete()) {
                    return FasterTripleStore.this.predicates.iterator(P, Node.ANY, Node.ANY);
                }
                return FasterTripleStore.this.subjects.iterateAll();
            }

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                Iterator it = this.find(d);
                while (it.hasNext()) {
                    if (!m.match(d, (Triple)it.next())) continue;
                    next.run(d);
                }
            }
        };
    }
}

