/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.n3;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import mx.com.hp.hpl.jena.graph.GraphEvents;
import mx.com.hp.hpl.jena.n3.N3Parser;
import mx.com.hp.hpl.jena.n3.N3ParserEventHandler;
import mx.com.hp.hpl.jena.n3.N3toRDF;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import mx.com.hp.hpl.jena.rdf.model.RDFReader;
import mx.com.hp.hpl.jena.shared.JenaException;

public class N3JenaReader
implements RDFReader {
    RDFErrorHandler errorHandler = null;
    N3toRDF converter = new N3toRDF();

    public void read(Model model, Reader r, String base) {
        this.read(model, r, base, null);
    }

    public void read(Model model, String url) {
        try {
            URLConnection conn = new URL(url).openConnection();
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                this.read(model, new InputStreamReader(conn.getInputStream()), url, url);
            } else {
                this.read(model, new InputStreamReader(conn.getInputStream(), encoding), url, url);
            }
        }
        catch (JenaException e) {
            if (this.errorHandler == null) {
                throw e;
            }
            this.errorHandler.error(e);
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException(ex);
            }
            this.errorHandler.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Model model, Reader r, String base, String sourceName) {
        try {
            model.notifyEvent(GraphEvents.startRead);
            this.converter.setBase(base);
            this.converter.setModel(model);
            N3Parser p = new N3Parser(r, (N3ParserEventHandler)this.converter);
            p.parse();
        }
        catch (JenaException e) {
            if (this.errorHandler == null) {
                throw e;
            }
            this.errorHandler.error(e);
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException(ex);
            }
            this.errorHandler.error(ex);
        }
        finally {
            model.notifyEvent(GraphEvents.finishRead);
        }
    }

    public void read(Model model, InputStream in, String base) {
        this.read(model, in, base, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Model model, InputStream in, String base, String sourceName) {
        try {
            model.notifyEvent(GraphEvents.startRead);
            this.converter.setBase(base);
            this.converter.setModel(model);
            N3Parser p = new N3Parser(in, (N3ParserEventHandler)this.converter);
            p.parse();
        }
        catch (JenaException e) {
            if (this.errorHandler == null) {
                throw e;
            }
            this.errorHandler.error(e);
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException(ex);
            }
            this.errorHandler.error(ex);
        }
        finally {
            model.notifyEvent(GraphEvents.finishRead);
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    public Object setProperty(String propName, Object propValue) {
        return null;
    }
}

