/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.daml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import mx.com.hp.hpl.jena.ontology.daml.DAMLCommon;
import mx.com.hp.hpl.jena.ontology.daml.DAMLProperty;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.DAML_OIL;

public class PropertyIterator
implements Iterator {
    protected LinkedList m_nodeQueue = new LinkedList();
    protected Property m_pred = null;
    protected Property m_inverse = null;
    protected HashSet m_predEquivs = new HashSet();
    protected HashSet m_inverseEquivs = new HashSet();
    protected boolean m_transitive = false;
    protected WeakHashMap m_seen = new WeakHashMap();
    protected Resource m_root = null;
    protected List m_roots = null;
    protected Object m_defaultValue = null;
    protected boolean m_defaultValueSeen = false;
    protected boolean m_useEquivalence = true;
    protected Model m_model = null;

    public PropertyIterator(Resource root, Property pred, Property inverse, boolean isTransitive, boolean isReflexive) {
        this(root, pred, inverse, isTransitive, isReflexive, true);
    }

    public PropertyIterator(Resource root, Property pred, Property inverse, boolean isTransitive, boolean isReflexive, boolean useEquivalence) {
        this.m_root = root;
        this.m_pred = pred;
        this.m_inverse = inverse;
        this.m_transitive = isTransitive;
        this.m_useEquivalence = useEquivalence;
        this.setModel();
        this.cachePropertyEquivs();
        if (isReflexive) {
            this.enqueue(root);
        } else {
            this.expandQueue(root);
        }
    }

    public PropertyIterator(Iterator roots, Property pred, Property inverse, boolean isTransitive, boolean isReflexive) {
        this(roots, pred, inverse, isTransitive, isReflexive, true);
    }

    public PropertyIterator(Iterator roots, Property pred, Property inverse, boolean isTransitive, boolean isReflexive, boolean useEquivalence) {
        this.m_roots = new ArrayList();
        this.m_pred = pred;
        this.m_inverse = inverse;
        this.m_transitive = isTransitive;
        this.m_useEquivalence = useEquivalence;
        this.setModel();
        this.cachePropertyEquivs();
        if (isReflexive) {
            while (roots.hasNext()) {
                Resource next = (Resource)roots.next();
                if (this.m_model == null && next.getModel() != null) {
                    this.m_model = next.getModel();
                }
                this.m_roots.add(next);
                this.enqueue(next);
            }
        } else {
            while (roots.hasNext()) {
                Resource next = (Resource)roots.next();
                if (this.m_model == null && next.getModel() != null) {
                    this.m_model = next.getModel();
                }
                this.m_roots.add(next);
                this.expandQueue(next);
            }
        }
    }

    public boolean hasNext() {
        return !this.m_nodeQueue.isEmpty() || this.hasDefaultValue() && !this.m_defaultValueSeen;
    }

    public Object next() {
        if (!this.m_nodeQueue.isEmpty()) {
            RDFNode next = (RDFNode)this.m_nodeQueue.removeFirst();
            if (this.hasDefaultValue() && this.m_defaultValue.equals(next)) {
                this.m_defaultValueSeen = true;
            }
            if (next instanceof Resource) {
                this.expandQueue((Resource)next);
            }
            return next;
        }
        if (this.hasDefaultValue() && !this.m_defaultValueSeen) {
            this.m_defaultValueSeen = true;
            return this.m_defaultValue;
        }
        throw new NoSuchElementException("Tried to access next() element from empty property iterator");
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a property iterator");
    }

    public void setDefaultValue(Object defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.m_defaultValue != null;
    }

    private void enqueue(RDFNode node) {
        if (!this.m_seen.containsKey(node)) {
            this.m_seen.put(node, Boolean.TRUE);
            this.m_nodeQueue.addLast(node);
            if (this.getUseEquivalence() && node instanceof DAMLCommon) {
                ExtendedIterator i = ((DAMLCommon)node).getEquivalentValues();
                while (i.hasNext()) {
                    this.enqueue((RDFNode)i.next());
                }
            }
        }
    }

    protected void expandQueue(Resource r) {
        Iterator i;
        if (this.m_pred != null && (this.m_transitive || this.isRoot(r))) {
            i = this.getStatementObjects(r);
            while (i.hasNext()) {
                this.enqueue((RDFNode)i.next());
            }
        }
        if (this.m_inverse != null && (this.m_transitive || this.isRoot(r))) {
            i = this.getStatementSubjects(r);
            while (i.hasNext()) {
                this.enqueue((RDFNode)i.next());
            }
        }
    }

    protected boolean isRoot(Resource r) {
        if (this.m_roots != null) {
            return this.m_roots.contains(r);
        }
        return r == this.m_root;
    }

    protected Iterator getStatementObjects(Resource res) {
        Iterator i = null;
        if (this.getUseEquivalence() && res instanceof DAMLCommon) {
            Iterator j = this.m_predEquivs.iterator();
            while (j.hasNext()) {
                PropertyIterator pIter = new PropertyIterator(res, (Property)j.next(), null, this.m_transitive, false, false);
                i = i == null ? pIter : new ConcatenatedIterator(pIter, i);
            }
        } else {
            i = this.m_model != null ? this.m_model.listObjectsOfProperty(res, this.m_pred) : new LinkedList().iterator();
        }
        return i;
    }

    protected Iterator getStatementSubjects(Resource res) {
        Iterator i = null;
        if (this.getUseEquivalence() && res instanceof DAMLCommon) {
            Iterator j = this.m_inverseEquivs.iterator();
            while (j.hasNext()) {
                PropertyIterator pIter = new PropertyIterator(res, null, (Property)j.next(), this.m_transitive, false, false);
                i = i == null ? pIter : new ConcatenatedIterator(pIter, i);
            }
        } else {
            i = this.m_model != null ? this.m_model.listSubjectsWithProperty(this.m_inverse, res) : new LinkedList().iterator();
        }
        return i;
    }

    protected void cachePropertyEquivs() {
        if (this.getUseEquivalence()) {
            ExtendedIterator i;
            if (this.m_pred != null) {
                if (this.m_pred instanceof DAMLProperty) {
                    i = ((DAMLProperty)this.m_pred).getEquivalentValues();
                    while (i.hasNext()) {
                        this.cacheProperty(this.m_predEquivs, (Property)i.next());
                    }
                } else {
                    this.cacheProperty(this.m_predEquivs, this.m_pred);
                }
            }
            if (this.m_inverse != null) {
                if (this.m_inverse instanceof DAMLProperty) {
                    i = ((DAMLProperty)this.m_inverse).getEquivalentValues();
                    while (i.hasNext()) {
                        this.cacheProperty(this.m_inverseEquivs, (Property)i.next());
                    }
                } else {
                    this.cacheProperty(this.m_inverseEquivs, this.m_inverse);
                }
            }
        }
    }

    protected void cacheProperty(HashSet s, Property p) {
        s.add(p);
        if (p instanceof DAMLProperty && !p.getLocalName().equals(DAML_OIL.subPropertyOf.getLocalName())) {
            ExtendedIterator i = ((DAMLProperty)p).getSubProperties();
            while (i.hasNext()) {
                s.add(i.next());
            }
        }
    }

    protected void setModel() {
        if (this.m_root != null && this.m_root.getModel() != null) {
            this.m_model = this.m_root.getModel();
            return;
        }
        if (this.m_pred != null && this.m_pred.getModel() != null) {
            this.m_model = this.m_pred.getModel();
            return;
        }
        if (this.m_inverse != null && this.m_inverse.getModel() != null) {
            this.m_model = this.m_inverse.getModel();
            return;
        }
        if (this.m_roots != null) {
            Iterator i = this.m_roots.iterator();
            while (i.hasNext()) {
                RDFNode n = (RDFNode)i.next();
                if (!(n instanceof Resource) || ((Resource)n).getModel() == null) continue;
                this.m_model = ((Resource)n).getModel();
                return;
            }
        }
    }

    protected boolean getUseEquivalence() {
        return false;
    }
}

