/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.daml.impl;

import java.util.HashSet;
import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.enhanced.Implementation;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.ontology.ConversionException;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.Profile;
import mx.com.hp.hpl.jena.ontology.daml.DAMLClass;
import mx.com.hp.hpl.jena.ontology.daml.DAMLCommon;
import mx.com.hp.hpl.jena.ontology.daml.DAMLInstance;
import mx.com.hp.hpl.jena.ontology.daml.DAMLModel;
import mx.com.hp.hpl.jena.ontology.daml.DAMLProperty;
import mx.com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import mx.com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import mx.com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import mx.com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import mx.com.hp.hpl.jena.ontology.daml.impl.VocabularyManager;
import mx.com.hp.hpl.jena.ontology.impl.OntClassImpl;
import mx.com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import mx.com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import mx.com.hp.hpl.jena.vocabulary.DAML_OIL;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class DAMLClassImpl
extends OntClassImpl
implements DAMLClass {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new DAMLClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to DAMLClass");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile;
            Profile profile2 = profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, class$mx$com$hp$hpl$jena$ontology$daml$DAMLClass == null ? (class$mx$com$hp$hpl$jena$ontology$daml$DAMLClass = DAMLClassImpl.class$("mx.com.hp.hpl.jena.ontology.daml.DAMLClass")) : class$mx$com$hp$hpl$jena$ontology$daml$DAMLClass);
        }
    };
    private PropertyAccessor m_propSubClassOf = new PropertyAccessorImpl(this.getProfile().SUB_CLASS_OF(), this);
    private PropertyAccessor m_propDisjointWith = new PropertyAccessorImpl(this.getProfile().DISJOINT_WITH(), this);
    private PropertyAccessor m_propDisjointUnionOf = new PropertyAccessorImpl(DAML_OIL.disjointUnionOf, this);
    private PropertyAccessor m_propSameClassAs = new PropertyAccessorImpl(this.getProfile().EQUIVALENT_CLASS(), this);
    private PropertyAccessor m_propOneOf = new PropertyAccessorImpl(this.getProfile().ONE_OF(), this);
    private PropertyAccessor m_propUnionOf = new PropertyAccessorImpl(this.getProfile().UNION_OF(), this);
    private PropertyAccessor m_propIntersectionOf = new PropertyAccessorImpl(this.getProfile().INTERSECTION_OF(), this);
    private PropertyAccessor m_propComplementOf = new PropertyAccessorImpl(this.getProfile().COMPLEMENT_OF(), this);
    protected DAMLCommon m_common = null;
    protected DAMLVocabulary m_vocabulary = VocabularyManager.getDefaultVocabulary();

    public DAMLClassImpl(Node n, EnhGraph g) {
        super(n, g);
        this.m_common = new DAMLCommonImpl(n, g);
    }

    public void setRDFType(Resource rdfClass, boolean replace) {
        this.m_common.setRDFType(rdfClass, replace);
    }

    public DAMLModel getDAMLModel() {
        return this.m_common.getDAMLModel();
    }

    public ExtendedIterator getRDFTypes(boolean complete) {
        return this.m_common.getRDFTypes(complete);
    }

    public DAMLVocabulary getVocabulary() {
        return this.m_vocabulary;
    }

    public LiteralAccessor prop_label() {
        return this.m_common.prop_label();
    }

    public LiteralAccessor prop_comment() {
        return this.m_common.prop_comment();
    }

    public PropertyAccessor prop_equivalentTo() {
        return this.m_common.prop_equivalentTo();
    }

    public PropertyAccessor prop_type() {
        return this.m_common.prop_type();
    }

    public ExtendedIterator getEquivalentValues() {
        ConcatenatedIterator i = new ConcatenatedIterator(this.m_common.getEquivalentValues(), this.getSameClasses());
        return UniqueExtendedIterator.create(i).mapWith(new OntResourceImpl.AsMapper(DAMLClass.class));
    }

    public ExtendedIterator getEquivalenceSet() {
        HashSet<DAMLClassImpl> s = new HashSet<DAMLClassImpl>();
        s.add(this);
        ExtendedIterator i = this.getEquivalentValues();
        while (i.hasNext()) {
            s.add((DAMLClassImpl)i.next());
        }
        s.remove(this);
        return WrappedIterator.create(s.iterator());
    }

    public PropertyAccessor prop_subClassOf() {
        return this.m_propSubClassOf;
    }

    public PropertyAccessor prop_disjointWith() {
        return this.m_propDisjointWith;
    }

    public PropertyAccessor prop_disjointUnionOf() {
        return this.m_propDisjointUnionOf;
    }

    public PropertyAccessor prop_sameClassAs() {
        return this.m_propSameClassAs;
    }

    public PropertyAccessor prop_unionOf() {
        return this.m_propUnionOf;
    }

    public PropertyAccessor prop_intersectionOf() {
        return this.m_propIntersectionOf;
    }

    public PropertyAccessor prop_complementOf() {
        return this.m_propComplementOf;
    }

    public PropertyAccessor prop_oneOf() {
        return this.m_propOneOf;
    }

    public boolean isEnumeration() {
        return this.hasProperty(this.getVocabulary().oneOf());
    }

    public boolean isNamedClass() {
        return !this.isAnon();
    }

    public boolean isRestriction() {
        return this.hasProperty(RDF.type, this.getProfile().RESTRICTION());
    }

    public boolean isIntersection() {
        return this.hasProperty(this.getVocabulary().intersectionOf());
    }

    public boolean isUnion() {
        return this.hasProperty(this.getVocabulary().unionOf());
    }

    public boolean isDisjointUnion() {
        return this.hasProperty(this.getVocabulary().disjointUnionOf());
    }

    public boolean isComplement() {
        return this.hasProperty(this.getVocabulary().complementOf());
    }

    public ExtendedIterator getSubClasses() {
        return this.getSubClasses(true);
    }

    public ExtendedIterator getSubClasses(boolean closed) {
        return WrappedIterator.create(super.listSubClasses(!closed)).mapWith(new OntResourceImpl.AsMapper(DAMLClass.class));
    }

    public ExtendedIterator getSuperClasses() {
        return this.getSuperClasses(true);
    }

    public ExtendedIterator getSuperClasses(boolean closed) {
        return WrappedIterator.create(super.listSuperClasses(!closed)).mapWith(new OntResourceImpl.AsMapper(DAMLClass.class));
    }

    public ExtendedIterator getSameClasses() {
        return WrappedIterator.create(super.listEquivalentClasses()).mapWith(new OntResourceImpl.AsMapper(DAMLClass.class));
    }

    public ExtendedIterator getInstances() {
        return WrappedIterator.create(this.listInstances()).mapWith(new OntResourceImpl.AsMapper(DAMLInstance.class));
    }

    public ExtendedIterator getDefinedProperties() {
        return this.getDefinedProperties(true);
    }

    public ExtendedIterator getDefinedProperties(boolean closed) {
        return WrappedIterator.create(this.listDeclaredProperties(!closed)).mapWith(new OntResourceImpl.AsMapper(DAMLProperty.class));
    }
}

