/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.daml.impl;

import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.datatypes.TypeMapper;
import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.enhanced.Implementation;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.ontology.ConversionException;
import mx.com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import mx.com.hp.hpl.jena.ontology.daml.impl.DAMLInstanceImpl;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import org.apache.commons.logging.LogFactory;

public class DAMLDataInstanceImpl
extends DAMLInstanceImpl
implements DAMLDataInstance {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new DAMLDataInstanceImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to DAMLDataInstance");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            return eg.asGraph().contains(node, RDF.type.asNode(), Node.ANY);
        }
    };

    public DAMLDataInstanceImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public RDFDatatype getDatatype() {
        ExtendedIterator i = this.listRDFTypes(true);
        while (i.hasNext()) {
            RDFDatatype dt;
            Resource rType = (Resource)i.next();
            if (rType.isAnon() || (dt = TypeMapper.getInstance().getTypeByName(rType.getURI())) == null) continue;
            if (i instanceof ClosableIterator) {
                ((ClosableIterator)i).close();
            }
            return dt;
        }
        return null;
    }

    public Object getValue() {
        if (this.hasProperty(RDF.value)) {
            RDFDatatype dType = this.getDatatype();
            if (dType == null) {
                LogFactory.getLog(this.getClass()).warn((Object)("No RDFDatatype defined for DAML data instance " + this));
            } else {
                return dType.parse(this.getRequiredProperty(RDF.value).getString());
            }
        }
        return null;
    }

    public void setValue(Object value) {
        this.setPropertyValue(RDF.value, "", this.getModel().createTypedLiteral(value, this.getDatatype()));
    }
}

