/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.daml.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.vocabulary.DAML_OIL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;

public class DAMLHierarchy {
    private static DAMLHierarchy s_instance = new DAMLHierarchy();
    public Resource[][] DAML_STANDARD_CLASS_HIERARCHY = new Resource[][]{{DAML_OIL.Class, RDFS.Class}, {DAML_OIL.Datatype, RDFS.Class}, {DAML_OIL.Restriction, DAML_OIL.Class}, {DAML_OIL.ObjectProperty, RDF.Property}, {DAML_OIL.DatatypeProperty, RDF.Property}, {DAML_OIL.TransitiveProperty, DAML_OIL.ObjectProperty}, {DAML_OIL.UnambiguousProperty, DAML_OIL.ObjectProperty}, {DAML_OIL.UniqueProperty, RDF.Property}, {DAML_OIL.List, RDF.Seq}};
    public Resource[][] DAML_STANDARD_EQUIVALENCES = new Resource[][]{{DAML_OIL.subClassOf, RDFS.subClassOf}, {DAML_OIL.Literal, RDFS.Literal}, {DAML_OIL.Property, RDF.Property}, {DAML_OIL.type, RDF.type}, {DAML_OIL.value, RDF.value}, {DAML_OIL.subPropertyOf, RDFS.subPropertyOf}, {DAML_OIL.domain, RDFS.domain}, {DAML_OIL.range, RDFS.range}, {DAML_OIL.label, RDFS.label}, {DAML_OIL.comment, RDFS.comment}, {DAML_OIL.seeAlso, RDFS.seeAlso}, {DAML_OIL.isDefinedBy, RDFS.isDefinedBy}};
    public Property[] TRANSITIVE_PROPERTIES = new Property[]{DAML_OIL.subClassOf, DAML_OIL.subPropertyOf, DAML_OIL.sameClassAs, DAML_OIL.sameIndividualAs, DAML_OIL.samePropertyAs, DAML_OIL.equivalentTo, RDFS.subClassOf, RDFS.subPropertyOf};
    protected Map m_classHierarchyMap = new HashMap();
    protected boolean m_initialised = false;
    protected Map m_equivalenceMap = new HashMap();
    protected Map m_transitiveProperties = new HashMap();

    private DAMLHierarchy() {
    }

    public static DAMLHierarchy getInstance() {
        return s_instance;
    }

    public boolean isDAMLSubClassOf(String uri0, String uri1) {
        if (uri0 == null || uri1 == null || uri0.length() == 0 || uri1.length() == 0) {
            return false;
        }
        this.initialiseMaps();
        String superClass = (String)this.m_classHierarchyMap.get(uri0);
        if (uri1.equals(superClass)) {
            return true;
        }
        return superClass == null ? false : this.isDAMLSubClassOf(superClass, uri1);
    }

    public boolean isTransitiveProperty(Resource res) {
        return res instanceof Property && this.m_transitiveProperties.containsKey(res);
    }

    public Iterator getEquivalentValues(Resource res) {
        this.initialiseMaps();
        LinkedList equivs = (LinkedList)this.m_equivalenceMap.get(res);
        return equivs == null ? new LinkedList().iterator() : equivs.iterator();
    }

    private void initialiseMaps() {
        if (!this.m_initialised) {
            int i;
            for (i = 0; i < this.DAML_STANDARD_CLASS_HIERARCHY.length; ++i) {
                String subClass = this.DAML_STANDARD_CLASS_HIERARCHY[i][0].getURI();
                String superClass = this.DAML_STANDARD_CLASS_HIERARCHY[i][1].getURI();
                this.m_classHierarchyMap.put(subClass, superClass);
            }
            for (i = 0; i < this.DAML_STANDARD_EQUIVALENCES.length; ++i) {
                LinkedList<Resource> l = (LinkedList<Resource>)this.m_equivalenceMap.get(this.DAML_STANDARD_EQUIVALENCES[i][0]);
                if (l == null) {
                    l = new LinkedList<Resource>();
                    this.m_equivalenceMap.put(this.DAML_STANDARD_EQUIVALENCES[i][0], l);
                }
                l.add(this.DAML_STANDARD_EQUIVALENCES[i][1]);
                l = (LinkedList<Resource>)this.m_equivalenceMap.get(this.DAML_STANDARD_EQUIVALENCES[i][1]);
                if (l == null) {
                    l = new LinkedList<Resource>();
                    this.m_equivalenceMap.put(this.DAML_STANDARD_EQUIVALENCES[i][1], l);
                }
                l.add(this.DAML_STANDARD_EQUIVALENCES[i][0]);
            }
            for (i = 0; i < this.TRANSITIVE_PROPERTIES.length; ++i) {
                this.m_transitiveProperties.put(this.TRANSITIVE_PROPERTIES[i], Boolean.TRUE);
            }
            this.m_initialised = true;
        }
    }
}

