/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.daml.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.ontology.daml.DAMLModel;
import mx.com.hp.hpl.jena.vocabulary.RDFS;

public class DAMLLoader {
    public static final String FILE_URI_PREFIX = "file://";
    public static final long STATUS_OK = 0L;
    public static final long STATUS_INPUT_UNAVAILABLE = 1L;
    public static final long STATUS_IO_ERROR = 2L;
    public static final long STATUS_SYNTAX_ERROR = 4L;
    public static final long STATUS_MISC_ERROR = 8L;
    private long m_status = 0L;
    private DAMLModel m_damlModel = null;
    private List m_importBlockList = new ArrayList();
    private boolean m_useImportBlocking = true;

    DAMLLoader(DAMLModel m) {
        this.m_damlModel = m;
        this.initialiseImportBlockList();
    }

    public DAMLModel getDAMLModel() {
        return this.m_damlModel;
    }

    protected void initialiseImportBlockList() {
        this.m_importBlockList.add("http://www.daml.org/2000/12/daml+oil#");
        this.m_importBlockList.add("http://www.daml.org/2001/03/daml+oil#");
        this.m_importBlockList.add(RDFS.getURI());
    }

    public Iterator getImportBlockList() {
        return this.m_importBlockList.iterator();
    }

    public boolean isBlockedImport(String uri) {
        return this.m_useImportBlocking && this.m_importBlockList.contains(uri);
    }

    public void addImportBlock(String uri) {
        if (!this.m_importBlockList.contains(uri)) {
            this.m_importBlockList.add(uri);
        }
    }

    public void removeImportBlock(String uri) {
        this.m_importBlockList.remove(uri);
    }

    public boolean getLoadImportedOntologies() {
        return this.m_damlModel.getDocumentManager().getProcessImports();
    }

    public void setLoadImportedOntologies(boolean loadImports) {
        this.m_damlModel.getDocumentManager().setProcessImports(loadImports);
    }

    public void setUseImportBlocking(boolean useBlocking) {
        this.m_useImportBlocking = useBlocking;
    }

    public boolean getUseImportBlocking() {
        return this.m_useImportBlocking;
    }

    public boolean isLoadedOntology(String uri) {
        return this.m_damlModel.hasLoadedImport(uri);
    }

    public long getStatus() {
        return this.m_status;
    }

    public void resetStatus() {
        this.m_status = 0L;
    }
}

