/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.daml.impl;

import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.enhanced.Implementation;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.ontology.ConversionException;
import mx.com.hp.hpl.jena.ontology.daml.DAMLOntology;
import mx.com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import mx.com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import mx.com.hp.hpl.jena.ontology.daml.impl.LiteralAccessorImpl;
import mx.com.hp.hpl.jena.rdf.model.NodeIterator;
import mx.com.hp.hpl.jena.vocabulary.DAML_OIL;

public class DAMLOntologyImpl
extends DAMLCommonImpl
implements DAMLOntology {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new DAMLOntologyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to DAMLOntology");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            return DAMLOntologyImpl.hasType(node, eg, DAML_OIL.Ontology);
        }
    };
    private LiteralAccessor m_propVersionInfo = null;

    public DAMLOntologyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public LiteralAccessor prop_versionInfo() {
        if (this.m_propVersionInfo == null) {
            this.m_propVersionInfo = new LiteralAccessorImpl(this.getVocabulary().versionInfo(), this);
        }
        return this.m_propVersionInfo;
    }

    public NodeIterator getImportedOntologies() {
        return this.listPropertyValues(DAML_OIL.imports);
    }

    public void addImportedOntology(String uri) {
        this.addProperty(this.getVocabulary().imports(), this.getModel().createLiteral(uri));
        if (this.getDAMLModel().getLoader().getLoadImportedOntologies()) {
            this.getModel().read(uri);
        }
    }
}

