/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.daml.impl;

import java.util.Iterator;
import mx.com.hp.hpl.jena.ontology.OntResource;
import mx.com.hp.hpl.jena.ontology.daml.DAMLCommon;
import mx.com.hp.hpl.jena.ontology.daml.DAMLList;
import mx.com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import mx.com.hp.hpl.jena.rdf.model.NodeIterator;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import mx.com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;

public class PropertyAccessorImpl
implements PropertyAccessor {
    protected Property m_property = null;
    protected OntResource m_val = null;

    public PropertyAccessorImpl(Property property, OntResource val) {
        this.m_property = property;
        this.m_val = val;
    }

    public Property getProperty() {
        return this.m_property;
    }

    public int count() {
        return this.m_val.getCardinality(this.getProperty());
    }

    public NodeIterator getAll() {
        return new NodeIteratorImpl((Iterator)UniqueExtendedIterator.create(this.m_val.listPropertyValues(this.getProperty())), null);
    }

    public RDFNode get() {
        return this.m_val.getPropertyValue(this.getProperty()).as(DAMLCommon.class);
    }

    public DAMLList getList() {
        RDFNode n = this.get();
        return n == null ? null : (DAMLList)n.as(DAMLList.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAMLCommon getDAMLValue() {
        NodeIterator i = null;
        try {
            i = this.getAll();
            while (i.hasNext()) {
                RDFNode n = (RDFNode)i.next();
                if (!n.canAs(class$mx$com$hp$hpl$jena$ontology$daml$DAMLCommon == null ? PropertyAccessorImpl.class$("mx.com.hp.hpl.jena.ontology.daml.DAMLCommon") : class$mx$com$hp$hpl$jena$ontology$daml$DAMLCommon)) continue;
                DAMLCommon dAMLCommon = (DAMLCommon)n.as(DAMLCommon.class);
                return dAMLCommon;
            }
            DAMLCommon dAMLCommon = null;
            return dAMLCommon;
        }
        finally {
            if (i != null) {
                i.close();
            }
        }
    }

    public void add(RDFNode value) {
        this.m_val.addProperty(this.getProperty(), value);
    }

    public void remove(RDFNode value) {
        this.m_val.removeProperty(this.getProperty(), value);
    }

    public boolean hasValue(RDFNode value) {
        return this.m_val.hasProperty(this.getProperty(), value);
    }
}

