/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.impl;

import java.util.Iterator;
import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.ontology.Profile;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.util.OneToManyMap;

public abstract class AbstractProfile
implements Profile {
    protected OneToManyMap m_aliasesMap;

    public boolean hasAliasFor(Resource res) {
        return this.aliasMap().containsKey(res);
    }

    public Resource getAliasFor(Resource res) {
        return (Resource)this.aliasMap().get(res);
    }

    public Iterator listAliasesFor(Resource res) {
        return this.aliasMap().getAll(res);
    }

    public static boolean containsSome(EnhGraph g, Node n, Property p) {
        return g.asGraph().contains(n, p.asNode(), Node.ANY);
    }

    protected abstract Resource[][] aliasTable();

    protected OneToManyMap aliasMap() {
        if (this.m_aliasesMap == null) {
            this.m_aliasesMap = new OneToManyMap();
            Resource[][] aliases = this.aliasTable();
            for (int i = 0; i < aliases.length; ++i) {
                this.m_aliasesMap.put(aliases[i][0], aliases[i][1]);
                this.m_aliasesMap.put(aliases[i][1], aliases[i][0]);
            }
        }
        return this.m_aliasesMap;
    }
}

