/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.impl;

import java.util.ArrayList;
import java.util.HashSet;
import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.enhanced.Implementation;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.query.BindingQueryPlan;
import mx.com.hp.hpl.jena.graph.query.Query;
import mx.com.hp.hpl.jena.ontology.ComplementClass;
import mx.com.hp.hpl.jena.ontology.ConversionException;
import mx.com.hp.hpl.jena.ontology.EnumeratedClass;
import mx.com.hp.hpl.jena.ontology.Individual;
import mx.com.hp.hpl.jena.ontology.IntersectionClass;
import mx.com.hp.hpl.jena.ontology.OntClass;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.OntProperty;
import mx.com.hp.hpl.jena.ontology.Profile;
import mx.com.hp.hpl.jena.ontology.Restriction;
import mx.com.hp.hpl.jena.ontology.UnionClass;
import mx.com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFList;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import mx.com.hp.hpl.jena.vocabulary.DAML_OIL;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class OntClassImpl
extends OntResourceImpl
implements OntClass {
    private static final String[] IGNORE_NAMESPACES = new String[]{"http://www.w3.org/2002/07/owl#", "http://www.daml.org/2001/03/daml+oil#", RDF.getURI(), RDFS.getURI(), "urn:x-hp-jena:rubrik/"};
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new OntClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to OntClass: it does not have rdf:type owl:Class or equivalent");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile;
            Profile profile2 = profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, class$mx$com$hp$hpl$jena$ontology$OntClass == null ? (class$mx$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("mx.com.hp.hpl.jena.ontology.OntClass")) : class$mx$com$hp$hpl$jena$ontology$OntClass);
        }
    };
    protected BindingQueryPlan m_domainQuery;
    protected BindingQueryPlan m_restrictionPropQuery = null;
    static /* synthetic */ Class class$mx$com$hp$hpl$jena$rdf$model$Property;

    public OntClassImpl(Node n, EnhGraph g) {
        super(n, g);
        Query q = new Query();
        q.addMatch(Query.X, this.getProfile().DOMAIN().asNode(), this.asNode());
        this.m_domainQuery = this.getModel().queryHandler().prepareBindings(q, new Node[]{Query.X});
        if (this.getProfile().ON_PROPERTY() != null) {
            q = new Query();
            q.addMatch(this.asNode(), this.getProfile().SUB_CLASS_OF().asNode(), Query.X);
            q.addMatch(Query.X, this.getProfile().ON_PROPERTY().asNode(), Query.Y);
            this.m_restrictionPropQuery = this.getModel().queryHandler().prepareBindings(q, new Node[]{Query.Y});
        }
    }

    public void setSuperClass(Resource cls) {
        this.setPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
    }

    public void addSuperClass(Resource cls) {
        this.addPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
    }

    public OntClass getSuperClass() {
        return (OntClass)this.objectAs(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class);
    }

    public ExtendedIterator listSuperClasses() {
        return this.listSuperClasses(false);
    }

    public ExtendedIterator listSuperClasses(boolean direct) {
        return UniqueExtendedIterator.create(this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), direct, false).filterDrop(new OntResourceImpl.SingleEqualityFilter(this, this)));
    }

    public boolean hasSuperClass(Resource cls) {
        return this.hasSuperClass(cls, false);
    }

    public boolean hasSuperClass() {
        return this.getSuperClass() != null;
    }

    public boolean hasSuperClass(Resource cls, boolean direct) {
        OntModel m;
        if (!direct) {
            return this.hasPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
        }
        InfGraph ig = null;
        if (this.getGraph() instanceof InfGraph) {
            ig = (InfGraph)((Object)this.getGraph());
        } else if (this.getGraph() instanceof OntModel && (m = (OntModel)((Object)this.getGraph())).getGraph() instanceof InfGraph) {
            ig = (InfGraph)m.getGraph();
        }
        if (ig != null && ig.getReasoner().supportsProperty(ReasonerVocabulary.directSubClassOf)) {
            return this.hasPropertyValue(ReasonerVocabulary.directSubClassOf, "direct sub-class", cls);
        }
        return this.hasSuperClassDirect(cls);
    }

    public void removeSuperClass(Resource cls) {
        this.removePropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", cls);
    }

    public void setSubClass(Resource cls) {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator i = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        while (i.hasNext()) {
            i.removeNext();
        }
        ((OntClass)cls.as(OntClass.class)).addSuperClass(this);
    }

    public void addSubClass(Resource cls) {
        ((OntClass)cls.as(OntClass.class)).addSuperClass(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntClass getSubClass() {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator i = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        try {
            if (i.hasNext()) {
                OntClass ontClass = (OntClass)i.nextStatement().getSubject().as(OntClass.class);
                return ontClass;
            }
            OntClass ontClass = null;
            return ontClass;
        }
        finally {
            i.close();
        }
    }

    public ExtendedIterator listSubClasses() {
        return this.listSubClasses(false);
    }

    public ExtendedIterator listSubClasses(boolean direct) {
        return UniqueExtendedIterator.create(this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), direct, true).filterDrop(new OntResourceImpl.SingleEqualityFilter(this, this)));
    }

    public boolean hasSubClass(Resource cls) {
        return this.hasSubClass(cls, false);
    }

    public boolean hasSubClass() {
        return this.getSubClass() != null;
    }

    public boolean hasSubClass(Resource cls, boolean direct) {
        if (this.getModel() instanceof OntModel && (cls.getModel() == null || !(cls.getModel() instanceof OntModel))) {
            cls = (Resource)cls.inModel(this.getModel());
        }
        return ((OntClass)cls.as(OntClass.class)).hasSuperClass(this, direct);
    }

    public void removeSubClass(Resource cls) {
        ((OntClass)cls.as(OntClass.class)).removeSuperClass(this);
    }

    public void setEquivalentClass(Resource cls) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    public void addEquivalentClass(Resource cls) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    public OntClass getEquivalentClass() {
        return (OntClass)this.objectAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class);
    }

    public ExtendedIterator listEquivalentClasses() {
        return UniqueExtendedIterator.create(this.listAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class));
    }

    public boolean hasEquivalentClass(Resource cls) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    public void removeEquivalentClass(Resource cls) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", cls);
    }

    public void setDisjointWith(Resource cls) {
        this.setPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    public void addDisjointWith(Resource cls) {
        this.addPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    public OntClass getDisjointWith() {
        return (OntClass)this.objectAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class);
    }

    public ExtendedIterator listDisjointWith() {
        return UniqueExtendedIterator.create(this.listAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class));
    }

    public boolean isDisjointWith(Resource cls) {
        return this.hasPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    public void removeDisjointWith(Resource cls) {
        this.removePropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", cls);
    }

    public ExtendedIterator listDeclaredProperties() {
        return this.listDeclaredProperties(false);
    }

    public ExtendedIterator listDeclaredProperties(boolean direct) {
        HashSet<RDFNode> candSet = new HashSet<RDFNode>();
        ExtendedIterator i = this.listAllProperties();
        while (i.hasNext()) {
            candSet.add(((Statement)i.next()).getSubject().as(class$mx$com$hp$hpl$jena$rdf$model$Property == null ? OntClassImpl.class$("mx.com.hp.hpl.jena.rdf.model.Property") : class$mx$com$hp$hpl$jena$rdf$model$Property));
        }
        ArrayList<RDFNode> cands = new ArrayList<RDFNode>();
        cands.addAll(candSet);
        for (int j = cands.size() - 1; j >= 0; --j) {
            Property cand = (Property)cands.get(j);
            if (this.hasDeclaredProperty(cand, direct)) continue;
            cands.remove(j);
        }
        return WrappedIterator.create(cands.iterator()).mapWith(new OntResourceImpl.AsMapper(OntProperty.class));
    }

    public boolean hasDeclaredProperty(Property p, boolean direct) {
        return this.testDomain(p, direct);
    }

    public ExtendedIterator listInstances() {
        return UniqueExtendedIterator.create(this.getModel().listStatements(null, RDF.type, this).mapWith(new OntResourceImpl.SubjectAsMapper(Individual.class)));
    }

    public Individual createIndividual() {
        return ((OntModel)this.getModel()).createIndividual(this);
    }

    public Individual createIndividual(String uri) {
        return ((OntModel)this.getModel()).createIndividual(uri, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHierarchyRoot() {
        if (this.equals(this.getProfile().NOTHING())) {
            return false;
        }
        ExtendedIterator i = null;
        try {
            i = this.listSuperClasses(true);
            while (i.hasNext()) {
                Resource sup = (Resource)i.next();
                if (((Object)sup).equals(this.getProfile().THING()) || ((Object)sup).equals(RDFS.Resource) || ((Object)sup).equals(this)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            i.close();
        }
        return true;
    }

    public EnumeratedClass asEnumeratedClass() {
        return (EnumeratedClass)this.as(EnumeratedClass.class);
    }

    public UnionClass asUnionClass() {
        return (UnionClass)this.as(UnionClass.class);
    }

    public IntersectionClass asIntersectionClass() {
        return (IntersectionClass)this.as(IntersectionClass.class);
    }

    public ComplementClass asComplementClass() {
        return (ComplementClass)this.as(ComplementClass.class);
    }

    public Restriction asRestriction() {
        return (Restriction)this.as(Restriction.class);
    }

    public boolean isEnumeratedClass() {
        this.checkProfile(this.getProfile().ONE_OF(), "ONE_OF");
        return this.hasProperty(this.getProfile().ONE_OF());
    }

    public boolean isUnionClass() {
        this.checkProfile(this.getProfile().UNION_OF(), "UNION_OF");
        return this.hasProperty(this.getProfile().UNION_OF());
    }

    public boolean isIntersectionClass() {
        this.checkProfile(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return this.hasProperty(this.getProfile().INTERSECTION_OF());
    }

    public boolean isComplementClass() {
        this.checkProfile(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return this.hasProperty(this.getProfile().COMPLEMENT_OF());
    }

    public boolean isRestriction() {
        this.checkProfile(this.getProfile().RESTRICTION(), "RESTRICTION");
        return this.hasProperty(this.getProfile().ON_PROPERTY()) || this.hasProperty(RDF.type, this.getProfile().RESTRICTION());
    }

    public EnumeratedClass convertToEnumeratedClass(RDFList individuals) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", individuals);
        return (EnumeratedClass)this.as(EnumeratedClass.class);
    }

    public IntersectionClass convertToIntersectionClass(RDFList classes) {
        this.setPropertyValue(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF", classes);
        return (IntersectionClass)this.as(IntersectionClass.class);
    }

    public UnionClass convertToUnionClass(RDFList classes) {
        this.setPropertyValue(this.getProfile().UNION_OF(), "UNION_OF", classes);
        return (UnionClass)this.as(UnionClass.class);
    }

    public ComplementClass convertToComplementClass(Resource cls) {
        this.setPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", cls);
        return (ComplementClass)this.as(ComplementClass.class);
    }

    public Restriction convertToRestriction(Property prop) {
        if (!this.hasRDFType(this.getProfile().RESTRICTION(), "RESTRICTION", false)) {
            this.setRDFType(this.getProfile().RESTRICTION());
        }
        this.setPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
        return (Restriction)this.as(Restriction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasSuperClassDirect(Resource cls) {
        ExtendedIterator i = this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "subClassOf", OntClass.class, this.getProfile().SUB_CLASS_OF(), true, false);
        try {
            while (i.hasNext()) {
                if (!((Object)cls).equals(i.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            i.close();
        }
        return false;
    }

    protected boolean testDomain(Property p, boolean direct) {
        String namespace = p.getNameSpace();
        for (int i = 0; i < IGNORE_NAMESPACES.length; ++i) {
            if (!namespace.equals(IGNORE_NAMESPACES[i])) continue;
            return false;
        }
        boolean isGlobal = true;
        boolean seenDirect = false;
        StmtIterator i = this.getModel().listStatements((Resource)p, this.getProfile().DOMAIN(), (RDFNode)null);
        while (i.hasNext()) {
            Resource domain = i.nextStatement().getResource();
            if (((Object)domain).equals(this.getProfile().THING()) || ((Object)domain).equals(RDFS.Resource)) continue;
            isGlobal = false;
            if (((Object)domain).equals(this)) {
                seenDirect = true;
                continue;
            }
            if (this.canProveSuperClass(domain)) continue;
            return false;
        }
        if (direct) {
            return seenDirect || isGlobal && this.isHierarchyRoot();
        }
        return true;
    }

    protected ExtendedIterator listAllProperties() {
        Model caps;
        OntModel mOnt = (OntModel)this.getModel();
        Profile prof = mOnt.getProfile();
        ExtendedIterator pi = mOnt.listStatements(null, RDF.type, this.getProfile().PROPERTY());
        if (mOnt.getReasoner() != null && ((caps = mOnt.getReasoner().getReasonerCapabilities()).contains(null, ReasonerVocabulary.supportsP, OWL.ObjectProperty) || caps.contains(null, ReasonerVocabulary.supportsP, DAML_OIL.ObjectProperty))) {
            return pi;
        }
        if (prof.OBJECT_PROPERTY() != null) {
            pi = pi.andThen(mOnt.listStatements(null, RDF.type, prof.OBJECT_PROPERTY()));
        }
        if (prof.DATATYPE_PROPERTY() != null) {
            pi = pi.andThen(mOnt.listStatements(null, RDF.type, prof.DATATYPE_PROPERTY()));
        }
        if (prof.FUNCTIONAL_PROPERTY() != null) {
            pi = pi.andThen(mOnt.listStatements(null, RDF.type, prof.FUNCTIONAL_PROPERTY()));
        }
        if (prof.INVERSE_FUNCTIONAL_PROPERTY() != null) {
            pi = pi.andThen(mOnt.listStatements(null, RDF.type, prof.INVERSE_FUNCTIONAL_PROPERTY()));
        }
        if (prof.SYMMETRIC_PROPERTY() != null) {
            pi = pi.andThen(mOnt.listStatements(null, RDF.type, prof.SYMMETRIC_PROPERTY()));
        }
        if (prof.TRANSITIVE_PROPERTY() != null) {
            pi = pi.andThen(mOnt.listStatements(null, RDF.type, prof.TRANSITIVE_PROPERTY()));
        }
        if (prof.ANNOTATION_PROPERTY() != null) {
            pi = pi.andThen(mOnt.listStatements(null, RDF.type, prof.ANNOTATION_PROPERTY()));
        }
        return pi;
    }

    protected boolean canProveSuperClass(Resource sup) {
        OntModel om = (OntModel)this.getModel();
        if (om.getReasoner() != null && om.getReasoner().getReasonerCapabilities().contains(null, ReasonerVocabulary.supportsP, RDFS.subClassOf)) {
            return this.hasSuperClass(sup);
        }
        HashSet<OntClass> seen = new HashSet<OntClass>();
        ArrayList<OntClassImpl> queue = new ArrayList<OntClassImpl>();
        queue.add(this);
        while (!queue.isEmpty()) {
            OntClass c = (OntClass)queue.remove(0);
            if (seen.contains(c)) continue;
            seen.add(c);
            if (c.equals(sup)) {
                return true;
            }
            ExtendedIterator i = c.listSuperClasses();
            while (i.hasNext()) {
                queue.add((OntClassImpl)i.next());
            }
        }
        return false;
    }
}

