/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.ontology.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.compose.MultiUnion;
import mx.com.hp.hpl.jena.graph.query.BindingQueryPlan;
import mx.com.hp.hpl.jena.graph.query.Query;
import mx.com.hp.hpl.jena.ontology.AllDifferent;
import mx.com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import mx.com.hp.hpl.jena.ontology.AnnotationProperty;
import mx.com.hp.hpl.jena.ontology.CardinalityQRestriction;
import mx.com.hp.hpl.jena.ontology.CardinalityRestriction;
import mx.com.hp.hpl.jena.ontology.ComplementClass;
import mx.com.hp.hpl.jena.ontology.ConversionException;
import mx.com.hp.hpl.jena.ontology.DataRange;
import mx.com.hp.hpl.jena.ontology.DatatypeProperty;
import mx.com.hp.hpl.jena.ontology.EnumeratedClass;
import mx.com.hp.hpl.jena.ontology.FunctionalProperty;
import mx.com.hp.hpl.jena.ontology.HasValueRestriction;
import mx.com.hp.hpl.jena.ontology.Individual;
import mx.com.hp.hpl.jena.ontology.IntersectionClass;
import mx.com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import mx.com.hp.hpl.jena.ontology.LanguageConsistencyException;
import mx.com.hp.hpl.jena.ontology.MaxCardinalityQRestriction;
import mx.com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import mx.com.hp.hpl.jena.ontology.MinCardinalityQRestriction;
import mx.com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import mx.com.hp.hpl.jena.ontology.OWLSyntaxChecker;
import mx.com.hp.hpl.jena.ontology.ObjectProperty;
import mx.com.hp.hpl.jena.ontology.OntClass;
import mx.com.hp.hpl.jena.ontology.OntDocumentManager;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.OntModelSpec;
import mx.com.hp.hpl.jena.ontology.OntProperty;
import mx.com.hp.hpl.jena.ontology.OntResource;
import mx.com.hp.hpl.jena.ontology.Ontology;
import mx.com.hp.hpl.jena.ontology.Profile;
import mx.com.hp.hpl.jena.ontology.ProfileException;
import mx.com.hp.hpl.jena.ontology.QualifiedRestriction;
import mx.com.hp.hpl.jena.ontology.Restriction;
import mx.com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import mx.com.hp.hpl.jena.ontology.SymmetricProperty;
import mx.com.hp.hpl.jena.ontology.TransitiveProperty;
import mx.com.hp.hpl.jena.ontology.UnionClass;
import mx.com.hp.hpl.jena.ontology.event.OntEventManager;
import mx.com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import mx.com.hp.hpl.jena.rdf.listeners.StatementListener;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.ModelMaker;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFList;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelCom;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ValidityReport;
import mx.com.hp.hpl.jena.shared.BrokenException;
import mx.com.hp.hpl.jena.shared.ConfigException;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.Filter;
import mx.com.hp.hpl.jena.util.iterator.Map1;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;
import mx.com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntModelImpl
extends ModelCom
implements OntModel {
    public static String owlSyntaxCheckerClassName = "com.hp.hpl.jena.ontology.tidy.JenaChecker";
    private static Log s_log = LogFactory.getLog((Class)OntModelImpl.class);
    private static Class owlSyntaxCheckerClass;
    protected OntModelSpec m_spec;
    protected Set m_imported = new HashSet();
    protected BindingQueryPlan m_individualsQueryNoInf0;
    protected BindingQueryPlan m_individualsQueryNoInf1;
    protected boolean m_strictMode = true;
    protected MultiUnion m_union = new MultiUnion();
    protected ImportsListener m_importsListener = null;
    protected OntEventManager m_ontEventMgr = null;
    private Model m_deductionsModel = null;

    public OntModelImpl(OntModelSpec spec, Model model) {
        this(spec, OntModelImpl.makeBaseModel(spec, model), false);
    }

    public OntModelImpl(OntModelSpec spec) {
        this(spec, spec.createBaseModel(), false);
    }

    private OntModelImpl(OntModelSpec spec, Model model, boolean overloadingTrick) {
        super(OntModelImpl.generateGraph(spec, model.getGraph()), BuiltinPersonalities.model);
        this.m_spec = spec;
        this.m_union = this.getGraph() instanceof MultiUnion ? (MultiUnion)this.getGraph() : (MultiUnion)((InfGraph)this.getGraph()).getRawGraph();
        this.m_individualsQueryNoInf0 = this.queryXTypeOfType(this.getProfile().CLASS());
        this.m_individualsQueryNoInf1 = this.queryXTypeOfType(this.getProfile().RESTRICTION());
        if (this.getDocumentManager().useDeclaredPrefixes()) {
            this.withDefaultMappings(this.getDocumentManager().getDeclaredPrefixMapping());
        }
        this.getDocumentManager().loadImports(this);
        this.rebind();
    }

    public OntDocumentManager getDocumentManager() {
        return this.m_spec.getDocumentManager();
    }

    public ExtendedIterator listOntologies() {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().ONTOLOGY(), Ontology.class));
    }

    public ExtendedIterator listOntProperties() {
        return UniqueExtendedIterator.create(this.findByTypeAs(RDF.Property, OntProperty.class));
    }

    public ExtendedIterator listObjectProperties() {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().OBJECT_PROPERTY(), ObjectProperty.class));
    }

    public ExtendedIterator listDatatypeProperties() {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().DATATYPE_PROPERTY(), DatatypeProperty.class));
    }

    public ExtendedIterator listFunctionalProperties() {
        this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().FUNCTIONAL_PROPERTY(), FunctionalProperty.class));
    }

    public ExtendedIterator listTransitiveProperties() {
        this.checkProfileEntry(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().TRANSITIVE_PROPERTY(), TransitiveProperty.class));
    }

    public ExtendedIterator listSymmetricProperties() {
        this.checkProfileEntry(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().SYMMETRIC_PROPERTY(), SymmetricProperty.class));
    }

    public ExtendedIterator listInverseFunctionalProperties() {
        this.checkProfileEntry(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), InverseFunctionalProperty.class));
    }

    public ExtendedIterator listIndividuals() {
        boolean supportsIndAsThing = false;
        if (this.getGraph() instanceof InfGraph) {
            supportsIndAsThing = ((InfGraph)this.getGraph()).getReasoner().getReasonerCapabilities().contains(null, ReasonerVocabulary.supportsP, ReasonerVocabulary.individualAsThingP);
        }
        if (!supportsIndAsThing || this.getProfile().THING() == null || ((Object)this.getProfile().CLASS()).equals(RDFS.Class)) {
            ExtendedIterator indivI = this.queryFor(this.m_individualsQueryNoInf0, null, Individual.class);
            if (this.m_individualsQueryNoInf1 != null) {
                indivI = indivI.andThen(this.queryFor(this.m_individualsQueryNoInf1, null, Individual.class));
            }
            if (this.getProfile().THING() != null) {
                indivI = indivI.andThen(this.findByTypeAs(this.getProfile().THING(), Individual.class));
            }
            return UniqueExtendedIterator.create(indivI);
        }
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().THING(), Individual.class));
    }

    public ExtendedIterator listIndividuals(Resource cls) {
        return UniqueExtendedIterator.create(this.findByTypeAs(cls, Individual.class));
    }

    public ExtendedIterator listClasses() {
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().getClassDescriptionTypes(), OntClass.class));
    }

    public ExtendedIterator listHierarchyRootClasses() {
        Model conf;
        if (this.getReasoner() != null && (conf = this.getReasoner().getReasonerCapabilities()).contains(null, ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubClassOf) && this.getProfile().THING() != null) {
            return this.listStatements(null, ReasonerVocabulary.directSubClassOf, this.getProfile().THING()).mapWith(new OntResourceImpl.SubjectAsMapper(OntClass.class));
        }
        return this.listClasses().filterDrop(new Filter(){

            public boolean accept(Object o) {
                return ((OntResource)o).isOntLanguageTerm();
            }
        }).filterKeep(new Filter(){

            public boolean accept(Object o) {
                return ((OntClass)o).isHierarchyRoot();
            }
        });
    }

    public ExtendedIterator listEnumeratedClasses() {
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().ONE_OF(), EnumeratedClass.class));
    }

    public ExtendedIterator listUnionClasses() {
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().UNION_OF(), UnionClass.class));
    }

    public ExtendedIterator listComplementClasses() {
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().COMPLEMENT_OF(), ComplementClass.class));
    }

    public ExtendedIterator listIntersectionClasses() {
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return UniqueExtendedIterator.create(this.findByDefiningPropertyAs(this.getProfile().INTERSECTION_OF(), IntersectionClass.class));
    }

    public ExtendedIterator listNamedClasses() {
        return this.listClasses().filterDrop(new Filter(){

            public boolean accept(Object x) {
                return ((Resource)x).isAnon();
            }
        });
    }

    public ExtendedIterator listRestrictions() {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().RESTRICTION(), Restriction.class));
    }

    public ExtendedIterator listAllDifferent() {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().ALL_DIFFERENT(), AllDifferent.class));
    }

    public ExtendedIterator listDataRanges() {
        this.checkProfileEntry(this.getProfile().DATARANGE(), "DATARANGE");
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().DATARANGE(), DataRange.class));
    }

    public ExtendedIterator listAnnotationProperties() {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        Resource r = this.getProfile().ANNOTATION_PROPERTY();
        if (r == null) {
            return NullIterator.instance;
        }
        return UniqueExtendedIterator.create(this.findByType(r).andThen(WrappedIterator.create(this.getProfile().getAnnotationProperties())).mapWith(new SubjectNodeAs(AnnotationProperty.class)));
    }

    public Ontology getOntology(String uri) {
        return (Ontology)this.findByURIAs(uri, Ontology.class);
    }

    public Individual getIndividual(String uri) {
        return (Individual)this.findByURIAs(uri, Individual.class);
    }

    public OntProperty getOntProperty(String uri) {
        return (OntProperty)this.findByURIAs(uri, OntProperty.class);
    }

    public ObjectProperty getObjectProperty(String uri) {
        return (ObjectProperty)this.findByURIAs(uri, ObjectProperty.class);
    }

    public TransitiveProperty getTransitiveProperty(String uri) {
        return (TransitiveProperty)this.findByURIAs(uri, TransitiveProperty.class);
    }

    public SymmetricProperty getSymmetricProperty(String uri) {
        return (SymmetricProperty)this.findByURIAs(uri, SymmetricProperty.class);
    }

    public InverseFunctionalProperty getInverseFunctionalProperty(String uri) {
        return (InverseFunctionalProperty)this.findByURIAs(uri, InverseFunctionalProperty.class);
    }

    public DatatypeProperty getDatatypeProperty(String uri) {
        return (DatatypeProperty)this.findByURIAs(uri, DatatypeProperty.class);
    }

    public AnnotationProperty getAnnotationProperty(String uri) {
        return (AnnotationProperty)this.findByURIAs(uri, AnnotationProperty.class);
    }

    public OntClass getOntClass(String uri) {
        Resource thing;
        OntClass c = (OntClass)this.findByURIAs(uri, OntClass.class);
        if (c == null && (thing = this.getProfile().THING()) != null) {
            Resource nothing = this.getProfile().NOTHING();
            if (thing.getURI().equals(uri)) {
                c = (OntClass)thing.inModel(this).as(OntClass.class);
            } else if (nothing.getURI().equals(uri)) {
                c = (OntClass)nothing.inModel(this).as(OntClass.class);
            }
        }
        return c;
    }

    public ComplementClass getComplementClass(String uri) {
        return (ComplementClass)this.findByURIAs(uri, ComplementClass.class);
    }

    public EnumeratedClass getEnumeratedClass(String uri) {
        return (EnumeratedClass)this.findByURIAs(uri, EnumeratedClass.class);
    }

    public UnionClass getUnionClass(String uri) {
        return (UnionClass)this.findByURIAs(uri, UnionClass.class);
    }

    public IntersectionClass getIntersectionClass(String uri) {
        return (IntersectionClass)this.findByURIAs(uri, IntersectionClass.class);
    }

    public Restriction getRestriction(String uri) {
        return (Restriction)this.findByURIAs(uri, Restriction.class);
    }

    public HasValueRestriction getHasValueRestriction(String uri) {
        return (HasValueRestriction)this.findByURIAs(uri, HasValueRestriction.class);
    }

    public SomeValuesFromRestriction getSomeValuesFromRestriction(String uri) {
        return (SomeValuesFromRestriction)this.findByURIAs(uri, SomeValuesFromRestriction.class);
    }

    public AllValuesFromRestriction getAllValuesFromRestriction(String uri) {
        return (AllValuesFromRestriction)this.findByURIAs(uri, AllValuesFromRestriction.class);
    }

    public CardinalityRestriction getCardinalityRestriction(String uri) {
        return (CardinalityRestriction)this.findByURIAs(uri, CardinalityRestriction.class);
    }

    public MinCardinalityRestriction getMinCardinalityRestriction(String uri) {
        return (MinCardinalityRestriction)this.findByURIAs(uri, MinCardinalityRestriction.class);
    }

    public MaxCardinalityRestriction getMaxCardinalityRestriction(String uri) {
        return (MaxCardinalityRestriction)this.findByURIAs(uri, MaxCardinalityRestriction.class);
    }

    public QualifiedRestriction getQualifiedRestriction(String uri) {
        return (QualifiedRestriction)this.findByURIAs(uri, QualifiedRestriction.class);
    }

    public CardinalityQRestriction getCardinalityQRestriction(String uri) {
        return (CardinalityQRestriction)this.findByURIAs(uri, CardinalityQRestriction.class);
    }

    public MinCardinalityQRestriction getMinCardinalityQRestriction(String uri) {
        return (MinCardinalityQRestriction)this.findByURIAs(uri, MinCardinalityQRestriction.class);
    }

    public MaxCardinalityQRestriction getMaxCardinalityQRestriction(String uri) {
        return (MaxCardinalityQRestriction)this.findByURIAs(uri, MaxCardinalityQRestriction.class);
    }

    public Ontology createOntology(String uri) {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return (Ontology)this.createOntResource(Ontology.class, this.getProfile().ONTOLOGY(), uri);
    }

    public Individual createIndividual(Resource cls) {
        return (Individual)this.createOntResource(Individual.class, cls, null);
    }

    public Individual createIndividual(String uri, Resource cls) {
        return (Individual)this.createOntResource(Individual.class, cls, uri);
    }

    public OntProperty createOntProperty(String uri) {
        Property p = this.createProperty(uri);
        p.addProperty(RDF.type, this.getProfile().PROPERTY());
        return (OntProperty)p.as(OntProperty.class);
    }

    public ObjectProperty createObjectProperty(String uri) {
        return this.createObjectProperty(uri, false);
    }

    public ObjectProperty createObjectProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        ObjectProperty p = (ObjectProperty)this.createOntResource(ObjectProperty.class, this.getProfile().OBJECT_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    public TransitiveProperty createTransitiveProperty(String uri) {
        return this.createTransitiveProperty(uri, false);
    }

    public TransitiveProperty createTransitiveProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY");
        TransitiveProperty p = (TransitiveProperty)this.createOntResource(TransitiveProperty.class, this.getProfile().TRANSITIVE_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    public SymmetricProperty createSymmetricProperty(String uri) {
        return this.createSymmetricProperty(uri, false);
    }

    public SymmetricProperty createSymmetricProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY");
        SymmetricProperty p = (SymmetricProperty)this.createOntResource(SymmetricProperty.class, this.getProfile().SYMMETRIC_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    public InverseFunctionalProperty createInverseFunctionalProperty(String uri) {
        return this.createInverseFunctionalProperty(uri, false);
    }

    public InverseFunctionalProperty createInverseFunctionalProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY");
        InverseFunctionalProperty p = (InverseFunctionalProperty)this.createOntResource(InverseFunctionalProperty.class, this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    public DatatypeProperty createDatatypeProperty(String uri) {
        return this.createDatatypeProperty(uri, false);
    }

    public DatatypeProperty createDatatypeProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        DatatypeProperty p = (DatatypeProperty)this.createOntResource(DatatypeProperty.class, this.getProfile().DATATYPE_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    public AnnotationProperty createAnnotationProperty(String uri) {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        return (AnnotationProperty)this.createOntResource(AnnotationProperty.class, this.getProfile().ANNOTATION_PROPERTY(), uri);
    }

    public OntClass createClass() {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), null);
    }

    public OntClass createClass(String uri) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
    }

    public ComplementClass createComplementClass(String uri, Resource cls) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        c.addProperty(this.getProfile().COMPLEMENT_OF(), cls == null ? this.getProfile().NOTHING() : cls);
        return (ComplementClass)c.as(ComplementClass.class);
    }

    public EnumeratedClass createEnumeratedClass(String uri, RDFList members) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        c.addProperty(this.getProfile().ONE_OF(), members == null ? this.createList() : members);
        return (EnumeratedClass)c.as(EnumeratedClass.class);
    }

    public UnionClass createUnionClass(String uri, RDFList members) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        c.addProperty(this.getProfile().UNION_OF(), members == null ? this.createList() : members);
        return (UnionClass)c.as(UnionClass.class);
    }

    public IntersectionClass createIntersectionClass(String uri, RDFList members) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = (OntClass)this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        c.addProperty(this.getProfile().INTERSECTION_OF(), members == null ? this.createList() : members);
        return (IntersectionClass)c.as(IntersectionClass.class);
    }

    public Restriction createRestriction(Property p) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), null);
        if (p != null) {
            r.setOnProperty(p);
        }
        return r;
    }

    public Restriction createRestriction(String uri, Property p) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (p != null) {
            r.setOnProperty(p);
        }
        return r;
    }

    public HasValueRestriction createHasValueRestriction(String uri, Property prop, RDFNode value) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null || value == null) {
            throw new IllegalArgumentException("Cannot create hasValueRestriction with a null property or value");
        }
        this.checkProfileEntry(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().HAS_VALUE(), value);
        return (HasValueRestriction)r.as(HasValueRestriction.class);
    }

    public SomeValuesFromRestriction createSomeValuesFromRestriction(String uri, Property prop, Resource cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null || cls == null) {
            throw new IllegalArgumentException("Cannot create someValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().SOME_VALUES_FROM(), cls);
        return (SomeValuesFromRestriction)r.as(SomeValuesFromRestriction.class);
    }

    public AllValuesFromRestriction createAllValuesFromRestriction(String uri, Property prop, Resource cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null || cls == null) {
            throw new IllegalArgumentException("Cannot create allValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().ALL_VALUES_FROM(), cls);
        return (AllValuesFromRestriction)r.as(AllValuesFromRestriction.class);
    }

    public CardinalityRestriction createCardinalityRestriction(String uri, Property prop, int cardinality) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create cardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().CARDINALITY(), "CARDINALITY");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().CARDINALITY(), this.createTypedLiteral(cardinality));
        return (CardinalityRestriction)r.as(CardinalityRestriction.class);
    }

    public MinCardinalityRestriction createMinCardinalityRestriction(String uri, Property prop, int cardinality) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create minCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MIN_CARDINALITY(), this.createTypedLiteral(cardinality));
        return (MinCardinalityRestriction)r.as(MinCardinalityRestriction.class);
    }

    public MaxCardinalityRestriction createMaxCardinalityRestriction(String uri, Property prop, int cardinality) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create maxCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MAX_CARDINALITY(), this.createTypedLiteral(cardinality));
        return (MaxCardinalityRestriction)r.as(MaxCardinalityRestriction.class);
    }

    public MaxCardinalityQRestriction createMaxCardinalityQRestriction(String uri, Property prop, int cardinality, OntClass cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create MaxCardinalityQRestriction with a null property");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Cannot create MaxCardinalityQRestriction with a null class");
        }
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MAX_CARDINALITY_Q(), this.createTypedLiteral(cardinality));
        r.addProperty(this.getProfile().HAS_CLASS_Q(), cls);
        return (MaxCardinalityQRestriction)r.as(MaxCardinalityQRestriction.class);
    }

    public MinCardinalityQRestriction createMinCardinalityQRestriction(String uri, Property prop, int cardinality, OntClass cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().MIN_CARDINALITY_Q(), "MIN_CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create MinCardinalityQRestriction with a null property");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Cannot create MinCardinalityQRestriction with a null class");
        }
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MIN_CARDINALITY_Q(), this.createTypedLiteral(cardinality));
        r.addProperty(this.getProfile().HAS_CLASS_Q(), cls);
        return (MinCardinalityQRestriction)r.as(MinCardinalityQRestriction.class);
    }

    public CardinalityQRestriction createCardinalityQRestriction(String uri, Property prop, int cardinality, OntClass cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create CardinalityQRestriction with a null property");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Cannot create CardinalityQRestriction with a null class");
        }
        Restriction r = (Restriction)this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().CARDINALITY_Q(), this.createTypedLiteral(cardinality));
        r.addProperty(this.getProfile().HAS_CLASS_Q(), cls);
        return (CardinalityQRestriction)r.as(CardinalityQRestriction.class);
    }

    public DataRange createDataRange(RDFList literals) {
        this.checkProfileEntry(this.getProfile().DATARANGE(), "DATARANGE");
        DataRange d = (DataRange)this.createOntResource(DataRange.class, this.getProfile().DATARANGE(), null);
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        d.addProperty(this.getProfile().ONE_OF(), literals == null ? this.createList() : literals);
        return d;
    }

    public AllDifferent createAllDifferent() {
        return this.createAllDifferent(null);
    }

    public AllDifferent createAllDifferent(RDFList differentMembers) {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        AllDifferent ad = (AllDifferent)this.createOntResource(AllDifferent.class, this.getProfile().ALL_DIFFERENT(), null);
        ad.setDistinctMembers(differentMembers == null ? this.createList() : differentMembers);
        return ad;
    }

    public OntResource createOntResource(Class javaClass, Resource rdfType, String uri) {
        return (OntResource)this.getResourceWithType(uri, rdfType).as(javaClass);
    }

    public OntResource createOntResource(String uri) {
        return (OntResource)this.getResource(uri).as(OntResource.class);
    }

    public RDFList createList() {
        Resource list = this.getResource(this.getProfile().NIL().getURI());
        return (RDFList)list.as(RDFList.class);
    }

    public Profile getProfile() {
        return this.m_spec.getProfile();
    }

    public boolean hasLoadedImport(String uri) {
        return this.m_imported.contains(uri);
    }

    public void addLoadedImport(String uri) {
        this.m_imported.add(uri);
    }

    public void removeLoadedImport(String uri) {
        this.m_imported.remove(uri);
    }

    public Set listImportedOntologyURIs() {
        return this.listImportedOntologyURIs(false);
    }

    public Set listImportedOntologyURIs(boolean closure) {
        HashSet<String> results = new HashSet<String>();
        ArrayList<Model> queue = new ArrayList<Model>();
        queue.add(this.getBaseModel());
        while (!queue.isEmpty()) {
            Model m = (Model)queue.remove(0);
            if (this.getProfile().ONTOLOGY() == null || this.getProfile().IMPORTS() == null) continue;
            StmtIterator i = m.listStatements(null, this.getProfile().IMPORTS(), (RDFNode)null);
            while (i.hasNext()) {
                Statement s = i.nextStatement();
                String uri = s.getResource().getURI();
                if (results.contains(uri)) continue;
                results.add(uri);
                Model mi = this.getDocumentManager().getModel(uri);
                if (!closure || mi == null || queue.contains(mi)) continue;
                queue.add(mi);
            }
        }
        return results;
    }

    public ModelMaker getImportModelMaker() {
        return this.m_spec.getImportModelMaker();
    }

    public ModelMaker getModelMaker() {
        return this.getImportModelMaker();
    }

    public Resource getOWLLanguageLevel(List problems) {
        OntModelImpl.initSyntaxCheckerClass();
        try {
            return ((OWLSyntaxChecker)owlSyntaxCheckerClass.newInstance()).getOWLLanguageLevel(this, problems);
        }
        catch (InstantiationException e) {
            throw new BrokenException("Syntax Checker misconfigured: ", e);
        }
        catch (IllegalAccessException e) {
            throw new BrokenException("Syntax Checker misconfigured: ", e);
        }
    }

    public Model read(String uri) {
        return this.read(uri, null);
    }

    public Model read(Reader reader, String base) {
        super.read(reader, base);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(InputStream reader, String base) {
        super.read(reader, base);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(String uri, String syntax) {
        return this.read(uri, uri, syntax);
    }

    public Model read(String uri, String base, String syntax) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Noting already loaded import URI " + uri));
        }
        this.addLoadedImport(uri);
        String sourceURL = this.getDocumentManager().doAltURLMapping(uri);
        super.read(sourceURL, base, syntax);
        this.getDocumentManager().addModel(uri, this);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(Reader reader, String base, String syntax) {
        super.read(reader, base, syntax);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public Model read(InputStream reader, String base, String syntax) {
        super.read(reader, base, syntax);
        this.getDocumentManager().loadImports(this);
        this.rebind();
        return this;
    }

    public List getSubGraphs() {
        return this.getUnionGraph().getSubGraphs();
    }

    public ExtendedIterator listImportedModels() {
        ExtendedIterator i = WrappedIterator.create(this.getSubGraphs().iterator());
        return i.mapWith(new Map1(){

            public Object map1(Object o) {
                Graph g = (Graph)o;
                Model temp = ModelFactory.createModelForGraph(g);
                return ModelFactory.createOntologyModel(OntModelImpl.this.m_spec, temp);
            }
        });
    }

    public OntModel getImportedModel(String uri) {
        Model mi;
        if (this.listImportedOntologyURIs(true).contains(uri) && (mi = this.getDocumentManager().getModel(uri)) != null) {
            if (mi instanceof OntModel) {
                return (OntModel)mi;
            }
            return ModelFactory.createOntologyModel(this.m_spec, mi);
        }
        return null;
    }

    public Graph getBaseGraph() {
        return this.getUnionGraph().getBaseGraph();
    }

    public Model getBaseModel() {
        Model result = ModelFactory.createModelForGraph(this.getBaseGraph());
        result.setNsPrefixes(this);
        return result;
    }

    public void addSubModel(Model model) {
        this.addSubModel(model, true);
    }

    public void addSubModel(Model model, boolean rebind) {
        this.getUnionGraph().addGraph(model.getGraph());
        if (rebind) {
            this.rebind();
        }
    }

    public void removeSubModel(Model model) {
        this.removeSubModel(model, true);
    }

    public void removeSubModel(Model model, boolean rebind) {
        Graph subG = model.getGraph();
        this.getUnionGraph().removeGraph(subG);
        if (subG instanceof MultiUnion) {
            this.getUnionGraph().removeGraph(((MultiUnion)subG).getBaseGraph());
        }
        if (rebind) {
            this.rebind();
        }
    }

    public boolean isInBaseModel(RDFNode node) {
        Node n = node.asNode();
        Graph b = this.getBaseGraph();
        return b.contains(n, Node.ANY, Node.ANY) || b.contains(Node.ANY, n, Node.ANY) || b.contains(Node.ANY, Node.ANY, n);
    }

    public boolean isInBaseModel(Statement stmt) {
        Node s = stmt.getSubject().asNode();
        Node p = stmt.getPredicate().asNode();
        Node o = stmt.getObject().asNode();
        Graph b = this.getBaseGraph();
        return b.contains(s, p, o);
    }

    public boolean strictMode() {
        return this.m_strictMode;
    }

    public void setStrictMode(boolean strict) {
        this.m_strictMode = strict;
    }

    public void setDynamicImports(boolean dynamic) {
        if (dynamic) {
            if (this.m_importsListener == null) {
                this.m_importsListener = new ImportsListener();
                this.register(this.m_importsListener);
            }
        } else if (this.m_importsListener != null) {
            this.unregister(this.m_importsListener);
            this.m_importsListener = null;
        }
    }

    public boolean getDynamicImports() {
        return this.m_importsListener != null;
    }

    public OntModelSpec getSpecification() {
        return this.m_spec;
    }

    public OntEventManager getEventManager() {
        if (this.m_ontEventMgr == null) {
            this.m_ontEventMgr = new OntEventManager(this);
        }
        return this.m_ontEventMgr;
    }

    public ExtendedIterator queryFor(BindingQueryPlan query2, List altQueries, Class asKey) {
        GetBinding firstBinding = new GetBinding(0);
        ExtendedIterator mainQuery = query2.executeBindings().mapWith(firstBinding);
        if (altQueries != null) {
            Iterator i = altQueries.iterator();
            while (i.hasNext()) {
                ExtendedIterator altQuery = ((BindingQueryPlan)i.next()).executeBindings().mapWith(firstBinding);
                mainQuery = mainQuery.andThen(altQuery);
            }
        }
        return mainQuery.filterKeep(new SubjectNodeCanAs(asKey)).mapWith(new SubjectNodeAs(asKey));
    }

    public Model write(Writer writer) {
        return this.getBaseModel().write(writer);
    }

    public Model write(Writer writer, String lang) {
        return this.getBaseModel().write(writer, lang);
    }

    public Model write(Writer writer, String lang, String base) {
        return this.getBaseModel().write(writer, lang, base);
    }

    public Model write(OutputStream out) {
        return this.getBaseModel().write(out);
    }

    public Model write(OutputStream out, String lang) {
        return this.getBaseModel().write(out, lang);
    }

    public Model write(OutputStream out, String lang, String base) {
        return this.getBaseModel().write(out, lang, base);
    }

    public Model writeAll(Writer writer, String lang, String base) {
        return super.write(writer, lang, base);
    }

    public Model writeAll(OutputStream out, String lang, String base) {
        return super.write(out, lang, base);
    }

    public Model getRawModel() {
        return this.getBaseModel();
    }

    public Reasoner getReasoner() {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).getReasoner() : null;
    }

    public void rebind() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).rebind();
        }
    }

    public void prepare() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).prepare();
        }
    }

    public void reset() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).reset();
        }
    }

    public Model getDeductionsModel() {
        Graph deductionsGraph;
        InfGraph infGraph;
        if (this.m_deductionsModel == null && (infGraph = this.getInfGraph()) != null && (deductionsGraph = infGraph.getDeductionsGraph()) != null) {
            this.m_deductionsModel = ModelFactory.createModelForGraph(deductionsGraph);
        }
        return this.m_deductionsModel;
    }

    public ValidityReport validate() {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).validate() : null;
    }

    public StmtIterator listStatements(Resource subject, Property predicate, RDFNode object, Model posit) {
        if (this.getGraph() instanceof InfGraph) {
            ExtendedIterator iter = ((InfGraph)this.getGraph()).find(subject.asNode(), predicate.asNode(), object.asNode(), posit.getGraph());
            return IteratorFactory.asStmtIterator(iter, this);
        }
        return null;
    }

    public void setDerivationLogging(boolean logOn) {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).setDerivationLogging(logOn);
        }
    }

    public Iterator getDerivation(Statement statement) {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).getDerivation(statement.asTriple()) : null;
    }

    private static void initSyntaxCheckerClass() {
        if (owlSyntaxCheckerClass == null) {
            try {
                owlSyntaxCheckerClass = Class.forName(owlSyntaxCheckerClassName);
                owlSyntaxCheckerClass.newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("owlsyntax.jar must be on the classpath.", e);
            }
        }
    }

    private static Graph generateGraph(OntModelSpec spec, Graph base) {
        MultiUnion u = new MultiUnion();
        u.addGraph(base);
        u.setBaseGraph(base);
        Reasoner r = spec.getReasoner();
        return r == null ? u : r.bind(u);
    }

    protected MultiUnion getUnionGraph() {
        return this.m_union;
    }

    protected Resource findByURIAs(String uri, Class asKey) {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot get() ontology value with a null URI");
        }
        Node n = Node.createURI(uri);
        if (this.getGraph().contains(n, Node.ANY, Node.ANY)) {
            try {
                return (Resource)((Object)this.getNodeAs(n, asKey));
            }
            catch (ConversionException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    protected ExtendedIterator findByType(Resource type) {
        return this.getGraph().find(null, RDF.type.asNode(), type.asNode());
    }

    protected ExtendedIterator findByType(Resource type, Iterator alternates) {
        ExtendedIterator i = this.findByType(type);
        if (alternates != null) {
            while (alternates.hasNext()) {
                i = i.andThen(this.findByType((Resource)alternates.next()));
            }
        }
        return UniqueExtendedIterator.create(i);
    }

    protected ExtendedIterator findByTypeAs(Resource type, Iterator types, Class asKey) {
        return this.findByType(type, types).mapWith(new SubjectNodeAs(asKey));
    }

    protected ExtendedIterator findByTypeAs(Iterator types, Class asKey) {
        return this.findByTypeAs((Resource)types.next(), types, asKey);
    }

    protected ExtendedIterator findByTypeAs(Resource type, Class asKey) {
        return this.findByType(type).mapWith(new SubjectNodeAs(asKey));
    }

    protected BindingQueryPlan queryXTypeOfType(Resource type) {
        if (type != null) {
            Query q = new Query();
            q.addMatch(Query.Y, RDF.type.asNode(), type.asNode());
            q.addMatch(Query.X, RDF.type.asNode(), Query.Y);
            return this.queryHandler().prepareBindings(q, new Node[]{Query.X});
        }
        return null;
    }

    protected ExtendedIterator findByDefiningProperty(Property p) {
        return this.getGraph().find(null, p.asNode(), null);
    }

    protected ExtendedIterator findByDefiningPropertyAs(Property p, Class asKey) {
        return this.findByDefiningProperty(p).mapWith(new SubjectNodeAs(asKey));
    }

    protected Resource getResourceWithType(String uri, Resource rdfType) {
        Resource r = this.getResource(uri);
        if (rdfType != null) {
            r.addProperty(RDF.type, rdfType);
        }
        return r;
    }

    public OntResource getOntResource(String uri) {
        Resource r = this.getResource(uri);
        if (this.containsResource(r)) {
            return (OntResource)r.as(OntResource.class);
        }
        return null;
    }

    public OntResource getOntResource(Resource res) {
        return (OntResource)res.inModel(this).as(OntResource.class);
    }

    protected void checkProfileEntry(Object profileTerm, String desc) {
        if (profileTerm == null) {
            throw new ProfileException(desc, this.getProfile());
        }
    }

    protected void checkListMembersRdfType(RDFList list, Resource rdfType) {
        if (this.strictMode() && !((Boolean)list.reduce(new RdfTypeTestFn(rdfType), Boolean.TRUE)).booleanValue()) {
            throw new LanguageConsistencyException("The members of the given list are expected to be of rdf:type " + ((Object)rdfType).toString());
        }
    }

    private static Model makeBaseModel(OntModelSpec spec, Model model) {
        return model == null ? spec.createBaseModel() : model;
    }

    private InfGraph getInfGraph() {
        return this.getGraph() instanceof InfGraph ? (InfGraph)this.getGraph() : null;
    }

    protected class ImportsListener
    extends StatementListener {
        protected ImportsListener() {
        }

        public void addedStatement(Statement added) {
            if (added.getPredicate().equals(OntModelImpl.this.getProfile().IMPORTS())) {
                OntModelImpl.this.getDocumentManager().loadImport(OntModelImpl.this, added.getResource().getURI());
            }
        }

        public void removedStatement(Statement removed) {
            if (removed.getPredicate().equals(OntModelImpl.this.getProfile().IMPORTS())) {
                OntModelImpl.this.getDocumentManager().unloadImport(OntModelImpl.this, removed.getResource().getURI());
            }
        }
    }

    protected class RdfTypeTestFn
    implements RDFList.ReduceFn {
        protected Resource m_type;

        protected RdfTypeTestFn(Resource type) {
            this.m_type = type;
        }

        public Object reduce(RDFNode node, Object accumulator) {
            Boolean acc = (Boolean)accumulator;
            if (acc.booleanValue()) {
                Resource r = (Resource)node;
                return new Boolean(r.hasProperty(RDF.type, this.m_type));
            }
            return acc;
        }
    }

    protected class GetBinding
    implements Map1 {
        protected int m_index;

        protected GetBinding(int index) {
            this.m_index = index;
        }

        public Object map1(Object x) {
            return ((List)x).get(this.m_index);
        }
    }

    protected class SubjectNodeCanAs
    extends Filter {
        protected Class m_asKey;

        protected SubjectNodeCanAs(Class asKey) {
            this.m_asKey = asKey;
        }

        public boolean accept(Object x) {
            Node n = x instanceof Triple ? ((Triple)x).getSubject() : (x instanceof EnhNode ? ((EnhNode)x).asNode() : (Node)x);
            try {
                OntModelImpl.this.getNodeAs(n, this.m_asKey);
            }
            catch (Exception ignore) {
                return false;
            }
            return true;
        }
    }

    protected class SubjectNodeAs
    implements Map1 {
        protected Class m_asKey;

        protected SubjectNodeAs(Class asKey) {
            this.m_asKey = asKey;
        }

        public Object map1(Object x) {
            Node n = x instanceof Triple ? ((Triple)x).getSubject() : (x instanceof EnhNode ? ((EnhNode)x).asNode() : (Node)x);
            return OntModelImpl.this.getNodeAs(n, this.m_asKey);
        }
    }
}

