/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.arp.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import mx.com.hp.hpl.jena.rdf.arp.FatalParsingErrorException;
import mx.com.hp.hpl.jena.rdf.arp.SAX2RDF;
import mx.com.hp.hpl.jena.rdf.arp.impl.WrappedException;
import mx.com.hp.hpl.jena.rdf.arp.impl.XMLHandler;
import mx.com.hp.hpl.jena.util.CharEncoding;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RDFXMLParser
extends XMLHandler {
    private SAXParser saxParser;
    private String readerXMLEncoding = null;
    private String xmlEncoding = null;

    private RDFXMLParser(SAXParser rdr) {
        this.saxParser = rdr;
        try {
            SAX2RDF.installHandlers((XMLReader)rdr, this);
        }
        catch (SAXException e) {
            throw new RuntimeException("Supposedly impossible:", e);
        }
    }

    public SAXParser getSAXParser() {
        return this.saxParser;
    }

    public static RDFXMLParser create() {
        RDFXMLParser a;
        StandardParserConfiguration c = new StandardParserConfiguration();
        MySAXParser msp = new MySAXParser(c);
        msp.a = a = new RDFXMLParser(msp);
        return a;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.parse(input, input.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(InputSource input, String base) throws IOException, SAXException {
        this.initParse(base, "");
        SAX2RDF.installHandlers((XMLReader)this.saxParser, this);
        this.saxParser.reset();
        this.initEncodingChecks(input);
        try {
            this.saxParser.parse(input);
        }
        catch (UTFDataFormatException e) {
            this.generalError(212, e);
        }
        catch (IOException e) {
            this.generalError(213, e);
        }
        catch (WrappedException wrapped) {
            wrapped.throwMe();
        }
        catch (FatalParsingErrorException fatalParsingErrorException) {
        }
        finally {
            this.afterParse();
        }
    }

    private void initEncodingChecks(InputSource in) {
        Reader rdr = in.getCharacterStream();
        this.readerXMLEncoding = null;
        this.encodingProblems = false;
        if (rdr != null && rdr instanceof InputStreamReader) {
            String javaEnc = ((InputStreamReader)rdr).getEncoding();
            this.readerXMLEncoding = CharEncoding.create(javaEnc).name();
        }
    }

    void setEncoding(String original) throws SAXParseException {
        CharEncoding encodingInfo = CharEncoding.create(original);
        String e = encodingInfo.name();
        if (this.xmlEncoding == null) {
            if (e.equals("UTF") && this.readerXMLEncoding != null && this.readerXMLEncoding.startsWith("UTF")) {
                this.xmlEncoding = this.readerXMLEncoding;
                return;
            }
            this.xmlEncoding = e;
            if (this.readerXMLEncoding != null && !this.readerXMLEncoding.equalsIgnoreCase(e)) {
                this.warning(null, 129, "Encoding on InputStreamReader or FileReader does not match that of XML document. Use FileInputStream. [" + this.readerXMLEncoding + " != " + e + "]");
                this.encodingProblems = true;
            }
            if (e.equals("UTF")) {
                return;
            }
            if (!encodingInfo.isIANA()) {
                this.warning(null, encodingInfo.isInNIO() ? 133 : 132, encodingInfo.warningMessage());
            } else if (!original.equalsIgnoreCase(e)) {
                this.warning(null, 134, "The encoding \"" + original + "\" is not the canonical name at IANA, suggest \"" + e + "\" would give more interoperability.");
            }
        }
    }

    private static class MySAXParser
    extends SAXParser {
        RDFXMLParser a;

        MySAXParser(StandardParserConfiguration c) {
            super((XMLParserConfiguration)c);
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) {
            try {
                this.a.setEncoding(encoding == null ? "UTF" : encoding);
            }
            catch (SAXParseException e) {
                throw new WrappedException(e);
            }
            super.xmlDecl(version, encoding, standalone, augs);
        }
    }
}

