/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.arp.lang;

import java.util.Vector;
import mx.com.hp.hpl.jena.rdf.arp.lang.IanaLanguageTag;
import mx.com.hp.hpl.jena.rdf.arp.lang.Iso3166;
import mx.com.hp.hpl.jena.rdf.arp.lang.Iso639;
import mx.com.hp.hpl.jena.rdf.arp.lang.LanguageTagCodes;
import mx.com.hp.hpl.jena.rdf.arp.lang.LanguageTagSyntaxException;

public class LanguageTag
implements LanguageTagCodes {
    String[] tags;

    public LanguageTag(String tag) throws LanguageTagSyntaxException {
        int subT;
        String lc = tag.toLowerCase();
        Vector<String> v = new Vector<String>();
        while ((subT = lc.indexOf(45)) != -1) {
            v.add(lc.substring(0, subT));
            lc = lc.substring(subT + 1);
        }
        v.add(lc);
        this.tags = new String[v.size()];
        v.copyInto(this.tags);
        int lg = this.tags[0].length();
        if (lg == 0 || lg > 8) {
            throw new LanguageTagSyntaxException("Primary subtag must be between 1 and 8 alpha characters: " + tag);
        }
        for (int j = 0; j < lg; ++j) {
            char ch = this.tags[0].charAt(j);
            if ('a' <= ch && ch <= 'z') continue;
            throw new LanguageTagSyntaxException("Primary subtag must be between 1 and 8 alpha characters: " + tag);
        }
        for (int i = 1; i < this.tags.length; ++i) {
            lg = this.tags[i].length();
            if (lg == 0 || lg > 8) {
                throw new LanguageTagSyntaxException("Subtag " + (i + 1) + " must be between 1 and 8 alphanumeric characters: " + tag);
            }
            for (int j = 0; j < lg; ++j) {
                char ch = this.tags[i].charAt(j);
                if ('a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9') continue;
                throw new LanguageTagSyntaxException("Subtag " + (i + 1) + " must be between 1 and 8 alphanumeric characters: " + tag);
            }
        }
    }

    public int tagType() {
        int rslt;
        IanaLanguageTag iana = IanaLanguageTag.find(this);
        Iso639 lang = Iso639.find(this.tags[0]);
        int n = rslt = iana == null ? 0 : iana.classification;
        if (iana != null && iana.tags.length < this.tags.length) {
            rslt |= 0x80;
        }
        switch (this.tags[0].length()) {
            case 1: {
                switch (this.tags[0].charAt(0)) {
                    case 'x': {
                        return 2;
                    }
                    case 'i': {
                        return iana != null ? rslt : 32768;
                    }
                }
                return 32768;
            }
            case 2: {
                if (lang == null) {
                    return 32768;
                }
                rslt |= lang.classification;
                break;
            }
            case 3: {
                if (lang == null) {
                    return 32768;
                }
                if (lang.twoCharCode != null) {
                    return 32768;
                }
                if (!lang.terminologyCode.equals(this.tags[0])) {
                    return 32768;
                }
                rslt |= lang.classification;
                break;
            }
            default: {
                return 32768;
            }
        }
        if (this.tags.length == 1) {
            return rslt;
        }
        switch (this.tags[1].length()) {
            case 1: {
                return 32768;
            }
            case 2: {
                if (Iso3166.find(this.tags[1]) != null) break;
                return 32768;
            }
            default: {
                if (iana != null) break;
                rslt |= 0x80;
            }
        }
        if (this.tags.length > 2 && iana == null) {
            rslt |= 0x80;
        }
        return rslt;
    }

    public String errorMessage() {
        switch (this.tags[0].length()) {
            case 1: {
                switch (this.tags[0].charAt(0)) {
                    case 'x': {
                        return null;
                    }
                    case 'i': {
                        if (IanaLanguageTag.find(this) != null) {
                            return null;
                        }
                        return this.toString() + " not found in IANA langauge registry.";
                    }
                }
                return "Only 'x' and 'i' single character primary language subtags are defined in RFC3066.";
            }
            case 2: {
                if (Iso639.find(this.tags[0]) != null) break;
                return "ISO-639 does not define langauge: '" + this.tags[0] + "'.";
            }
            case 3: {
                Iso639 lang = Iso639.find(this.tags[0]);
                if (lang == null) {
                    return "ISO-639 does not define langauge: '" + this.tags[0] + "'.";
                }
                if (lang.twoCharCode != null) {
                    return "RFC 3066 section 2.3 mandates the use of '" + lang.twoCharCode + "' instead of '" + this.tags[0] + "'.";
                }
                if (lang.terminologyCode.equals(this.tags[0])) break;
                return "RFC 3066 section 2.3 mandates the use of '" + lang.terminologyCode + "' instead of '" + this.tags[0] + "'.";
            }
            default: {
                return "No primary language subtags of length greater than 3 are currently defined.";
            }
        }
        if (this.tags.length == 1) {
            return null;
        }
        switch (this.tags[1].length()) {
            case 1: {
                return "Second language subtags of length 1 are prohibited by RFC3066.";
            }
            case 2: {
                if (Iso3166.find(this.tags[1]) != null) break;
                return "Country code, '" + this.tags[1] + "', not found in ISO 3166.";
            }
        }
        return null;
    }
}

