/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.arp.states;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import mx.com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext;
import mx.com.hp.hpl.jena.rdf.arp.impl.XMLHandler;
import mx.com.hp.hpl.jena.rdf.arp.states.Frame;
import mx.com.hp.hpl.jena.rdf.arp.states.FrameI;
import mx.com.hp.hpl.jena.rdf.arp.states.InnerXMLLiteral;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public abstract class AbsXMLLiteral
extends Frame {
    boolean checkComposingChar = true;
    static Map xmlNameSpace = new TreeMap();
    protected final StringBuffer rslt;
    public final Map namespaces;

    String suggestParsetypeLiteral() {
        return "";
    }

    private static String prefix(String qname) {
        int colon = qname.indexOf(58);
        return colon == -1 ? "" : qname.substring(0, colon);
    }

    protected void append(String s) {
        this.rslt.append(s);
    }

    private void append(char[] ch, int s, int l) {
        this.rslt.append(ch, s, l);
    }

    protected void append(char s) {
        this.rslt.append(s);
    }

    public AbsXMLLiteral(FrameI p, AbsXMLContext x, StringBuffer r) {
        super(p, x);
        this.rslt = r;
        this.namespaces = xmlNameSpace;
    }

    public AbsXMLLiteral(AbsXMLLiteral p, Map ns) {
        super((FrameI)p, p.xml);
        this.rslt = p.rslt;
        this.namespaces = ns;
    }

    public AbsXMLLiteral(XMLHandler h, AbsXMLContext x) {
        super(h, x);
        this.rslt = new StringBuffer();
        this.namespaces = xmlNameSpace;
    }

    private void useNameSpace(String prefix, String uri, Map ns) {
        if (!uri.equals(this.namespaces.get(prefix))) {
            ns.put(prefix, uri);
        }
    }

    public abstract void endElement() throws SAXParseException;

    void startLitElement(String uri, String rawName, Map ns) {
        this.append('<');
        this.append(rawName);
        this.useNameSpace(AbsXMLLiteral.prefix(rawName), uri, ns);
    }

    private void appendAttrValue(String s) {
        for (int i = 0; i < s.length(); ++i) {
            String replace;
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    replace = "&amp;";
                    break;
                }
                case '<': {
                    replace = "&lt;";
                    break;
                }
                case '\"': {
                    replace = "&quot;";
                    break;
                }
                case '\t': {
                    replace = "&#x9;";
                    break;
                }
                case '\n': {
                    replace = "&#xA;";
                    break;
                }
                case '\r': {
                    replace = "&#xD;";
                    break;
                }
                default: {
                    replace = null;
                }
            }
            if (replace != null) {
                this.append(replace);
                continue;
            }
            this.append(ch);
        }
    }

    public void characters(char[] chrs, int start, int length) throws SAXParseException {
        if (this.checkComposingChar) {
            this.checkComposingChar(this.taint, chrs, start, length);
        }
        this.checkComposingChar = false;
        for (int i = 0; i < length; ++i) {
            String replace;
            char ch = chrs[start + i];
            switch (ch) {
                case '&': {
                    replace = "&amp;";
                    break;
                }
                case '<': {
                    replace = "&lt;";
                    break;
                }
                case '>': {
                    replace = "&gt;";
                    break;
                }
                case '\r': {
                    replace = "&#xD;";
                    break;
                }
                default: {
                    replace = null;
                }
            }
            if (replace != null) {
                this.append(replace);
                continue;
            }
            this.append(ch);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXParseException {
        this.append("<!--");
        this.append(ch, start, length);
        this.append("-->");
        this.checkComposingChar = true;
    }

    public void processingInstruction(String target, String data) {
        this.append("<?");
        this.append(target);
        this.append(' ');
        this.append(data);
        this.append("?>");
        this.checkComposingChar = true;
    }

    public FrameI startElement(String uri, String localName, String rawName, Attributes atts) {
        String prefix;
        Map.Entry pair;
        this.checkComposingChar = true;
        TreeMap<String, String> attrMap = new TreeMap<String, String>();
        Map childNameSpaces = new TreeMap();
        this.startLitElement(uri, rawName, childNameSpaces);
        for (int i = atts.getLength() - 1; i >= 0; --i) {
            String ns = atts.getURI(i);
            String qname = atts.getQName(i);
            if (!uri.equals("")) {
                this.useNameSpace(AbsXMLLiteral.prefix(qname), ns, childNameSpaces);
            }
            attrMap.put(qname, atts.getValue(i));
        }
        Iterator it = childNameSpaces.entrySet().iterator();
        while (it.hasNext()) {
            pair = it.next();
            this.append(" xmlns");
            prefix = (String)pair.getKey();
            if (!"".equals(prefix)) {
                this.append(':');
                this.append(prefix);
            }
            this.append("=\"");
            this.appendAttrValue((String)pair.getValue());
            this.append('\"');
        }
        it = attrMap.entrySet().iterator();
        while (it.hasNext()) {
            pair = it.next();
            this.append(' ');
            this.append((String)pair.getKey());
            this.append("=\"");
            this.appendAttrValue((String)pair.getValue());
            this.append('\"');
        }
        this.append('>');
        if (childNameSpaces.isEmpty()) {
            childNameSpaces = this.namespaces;
        } else {
            it = this.namespaces.entrySet().iterator();
            while (it.hasNext()) {
                pair = it.next();
                prefix = (String)pair.getKey();
                if (childNameSpaces.containsKey(prefix)) continue;
                childNameSpaces.put(prefix, pair.getValue());
            }
        }
        return new InnerXMLLiteral(this, rawName, childNameSpaces);
    }

    static {
        xmlNameSpace.put("xml", xmlns);
        xmlNameSpace.put("", "");
    }
}

