/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Selector;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelCom;

public class SimpleSelector
implements Selector {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;

    public SimpleSelector() {
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    public SimpleSelector(Resource subject, Property predicate, RDFNode object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public SimpleSelector(Resource subject, Property predicate, boolean object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, long object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, char object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, float object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, double object) {
        this(subject, predicate, String.valueOf(object));
    }

    public SimpleSelector(Resource subject, Property predicate, String object) {
        this(subject, predicate, object, "");
    }

    public SimpleSelector(Resource subject, Property predicate, String object, String language) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object != null ? this.literal(object, language) : null;
    }

    private Literal literal(String s, String lang) {
        return new LiteralImpl(Node.createLiteral(s, lang, false), (ModelCom)null);
    }

    public SimpleSelector(Resource subject, Property predicate, Object object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object != null ? this.literal(object.toString(), "") : null;
    }

    public Resource getSubject() {
        return this.subject;
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public boolean isSimple() {
        return this.getClass() == SimpleSelector.class;
    }

    public boolean test(Statement s) {
        return !(this.subject != null && !((Object)this.subject).equals(s.getSubject()) || this.predicate != null && !this.predicate.equals(s.getPredicate()) || this.object != null && !this.object.equals(s.getObject()) || !this.selects(s));
    }

    public boolean selects(Statement s) {
        return true;
    }
}

