/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import java.util.Vector;
import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Container;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.NodeIterator;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.rdf.model.impl.ContNodeIteratorFactoryImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.ContainerI;
import mx.com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelCom;
import mx.com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import mx.com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import mx.com.hp.hpl.jena.shared.AssertionFailureException;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class ContainerImpl
extends ResourceImpl
implements Container,
ContainerI {
    static NodeIteratorFactory iteratorFactory = new ContNodeIteratorFactoryImpl();

    public ContainerImpl(ModelCom model) {
        super(model);
    }

    public ContainerImpl(String uri, ModelCom model) {
        super(uri, model);
    }

    public ContainerImpl(Resource r, ModelCom model) {
        super(r.asNode(), model);
    }

    public ContainerImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    protected ContainerImpl(Resource r) {
        this(r, (ModelCom)r.getModel());
    }

    private boolean is(Resource r) {
        return this.hasProperty(RDF.type, r);
    }

    public boolean isAlt() {
        return this.is(RDF.Alt);
    }

    public boolean isBag() {
        return this.is(RDF.Bag);
    }

    public boolean isSeq() {
        return this.is(RDF.Seq);
    }

    public Container add(RDFNode n) {
        int i = this.size();
        this.addProperty(RDF.li(i + 1), n);
        return this;
    }

    public Container add(boolean o) {
        return this.add(String.valueOf(o));
    }

    public Container add(long o) {
        return this.add(String.valueOf(o));
    }

    public Container add(char o) {
        return this.add(String.valueOf(o));
    }

    public Container add(float o) {
        return this.add(String.valueOf(o));
    }

    public Container add(double o) {
        return this.add(String.valueOf(o));
    }

    public Container add(Object o) {
        return this.add(String.valueOf(o));
    }

    public Container add(String o) {
        return this.add(o, "");
    }

    public Container add(String o, String l) {
        return this.add(this.literal(o, l));
    }

    public boolean contains(RDFNode n) {
        return this.containerContains(n);
    }

    public boolean contains(boolean o) {
        return this.contains(String.valueOf(o));
    }

    public boolean contains(long o) {
        return this.contains(String.valueOf(o));
    }

    public boolean contains(char o) {
        return this.contains(String.valueOf(o));
    }

    public boolean contains(float o) {
        return this.contains(String.valueOf(o));
    }

    public boolean contains(double o) {
        return this.contains(String.valueOf(o));
    }

    public boolean contains(Object o) {
        return this.contains(String.valueOf(o));
    }

    public boolean contains(String o) {
        return this.contains(o, "");
    }

    public boolean contains(String o, String l) {
        return this.contains(this.literal(o, l));
    }

    private Literal literal(String s, String lang) {
        return new LiteralImpl(Node.createLiteral(s, lang, false), this.getModelCom());
    }

    public NodeIterator iterator() {
        return this.listContainerMembers(iteratorFactory);
    }

    public int size() {
        int result = 0;
        StmtIterator iter = this.listProperties();
        while (iter.hasNext()) {
            if (iter.nextStatement().getPredicate().getOrdinal() == 0) continue;
            ++result;
        }
        iter.close();
        return result;
    }

    public Container remove(Statement s) {
        int size = this.size();
        Statement last = null;
        if (s.getPredicate().getOrdinal() == size) {
            this.getModel().remove(s);
        } else {
            last = this.getModel().getRequiredProperty(this, RDF.li(size));
            s.changeObject(last.getObject());
            this.getModel().remove(last);
        }
        if (this.size() != size - 1) {
            throw new AssertionFailureException("container size");
        }
        return this;
    }

    public Container remove(int index, RDFNode object) {
        this.remove(this.getModel().createStatement((Resource)this, RDF.li(index), object));
        return this;
    }

    public NodeIterator listContainerMembers(NodeIteratorFactory f) {
        StmtIterator iter = this.listProperties();
        Vector<Statement> result = new Vector<Statement>();
        int maxOrdinal = 0;
        while (iter.hasNext()) {
            Statement stmt = iter.nextStatement();
            int ordinal = stmt.getPredicate().getOrdinal();
            if (ordinal == 0) continue;
            if (ordinal > maxOrdinal) {
                maxOrdinal = ordinal;
                result.setSize(ordinal);
            }
            result.setElementAt(stmt, ordinal - 1);
        }
        iter.close();
        return f.createIterator(result.iterator(), result, this);
    }

    public int containerIndexOf(RDFNode n) {
        int result = 0;
        StmtIterator iter = this.listProperties();
        while (iter.hasNext()) {
            Statement stmt = iter.nextStatement();
            int ordinal = stmt.getPredicate().getOrdinal();
            if (ordinal == 0 || !n.equals(stmt.getObject())) continue;
            result = ordinal;
            break;
        }
        iter.close();
        return result;
    }

    public boolean containerContains(RDFNode n) {
        return this.containerIndexOf(n) != 0;
    }
}

