/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleBoundary;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelExtract;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StatementBoundary;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.rdf.model.impl.InfModelImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.reasoner.ReasonerRegistry;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.WrappedReasonerFactory;
import mx.com.hp.hpl.jena.shared.NoReasonerSuppliedException;
import mx.com.hp.hpl.jena.shared.NoSuchReasonerException;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;

public class InfModelSpec
extends ModelSpecImpl {
    protected Resource reasonerResource;
    protected Resource reasonerRoot;
    protected ReasonerFactory factory;
    private static final TripleBoundary notJMSTriple = new TripleBoundary(){

        public boolean stopAt(Triple t) {
            return !t.getPredicate().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#");
        }
    };
    private static final StatementBoundary notJMS = new StatementBoundary(){

        public boolean stopAt(Statement s) {
            return notJMSTriple.stopAt(s.asTriple());
        }

        public TripleBoundary asTripleBoundary(Model ignored) {
            return notJMSTriple;
        }
    };

    public InfModelSpec(Resource root, Model description) {
        super(root, description);
        Statement st = description.getRequiredProperty(null, JenaModelSpec.reasoner);
        Statement xx = description.listStatements(root, JenaModelSpec.reasonsWith, (RDFNode)null).nextStatement();
        this.reasonerRoot = st.getSubject();
        Resource yy = xx.getResource();
        this.reasonerResource = st.getResource();
        this.factory = InfModelSpec.getReasonerFactory(st.getSubject(), description);
    }

    public Model doCreateModel() {
        return this.createModel(this.maker.getGraphMaker().createGraph());
    }

    public Model implementCreateModelOver(String name) {
        return this.createModel(this.maker.getGraphMaker().createGraph(name));
    }

    protected Model createModel(Graph base) {
        Reasoner reasoner = this.factory.create(null);
        return new InfModelImpl(reasoner.bind(base));
    }

    public Property getMakerProperty() {
        return JenaModelSpec.maker;
    }

    public Model addDescription(Model desc, Resource self) {
        super.addDescription(desc, self);
        Resource r = this.reasonerRoot;
        desc.add(self, JenaModelSpec.reasonsWith, r);
        desc.add(r, JenaModelSpec.reasoner, this.reasonerResource);
        new ModelExtract(notJMS).extractInto(desc, r, this.description);
        return desc;
    }

    public static ReasonerFactory getReasonerFactory(Resource R, Model rs) {
        StmtIterator r = rs.listStatements(R, JenaModelSpec.reasoner, (RDFNode)null);
        if (!r.hasNext()) {
            throw new NoReasonerSuppliedException();
        }
        Resource rr = r.nextStatement().getResource();
        String rrs = rr.getURI();
        ReasonerFactory rf = ReasonerRegistry.theRegistry().getFactory(rrs);
        if (rf == null) {
            throw new NoSuchReasonerException(rrs);
        }
        return new WrappedReasonerFactory(rf, (Resource)R.inModel(rs));
    }
}

