/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.ModelSpec;
import mx.com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import mx.com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.shared.BadDescriptionException;
import mx.com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import mx.com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;

public class ModelSpecFactory {
    protected static ModelSpecCreatorRegistry defaultRegistry = ModelSpecCreatorRegistry.instance;
    protected static final RDFNode nullObject = null;
    static /* synthetic */ Class class$mx$com$hp$hpl$jena$rdf$model$Property;

    protected static ModelSpec create(ModelSpecCreatorRegistry registry, Model m, Resource root) {
        Resource type = ModelSpecFactory.findSpecificType(root, JenaModelSpec.ModelSpec);
        ModelSpecCreator sc = registry.getCreator(type);
        if (sc == null) {
            throw new BadDescriptionException("no model-spec creator found for " + type, m);
        }
        return sc.create(root, m);
    }

    public static ModelSpec createSpec(ModelSpecCreatorRegistry registry, Model m) {
        Model full = ModelSpecFactory.withSchema(m);
        return ModelSpecFactory.create(registry, full, ModelSpecFactory.findRootByType(full, JenaModelSpec.ModelSpec));
    }

    public static ModelSpec createSpec(Model m, Resource root) {
        Model full = ModelSpecFactory.withSchema(m);
        return ModelSpecFactory.create(defaultRegistry, full, (Resource)root.inModel(full));
    }

    public static ModelSpec createSpec(Model m) {
        Model full = ModelSpecFactory.withSchema(m);
        return ModelSpecFactory.create(defaultRegistry, full, ModelSpecFactory.findRootByType(full, JenaModelSpec.ModelSpec));
    }

    public static Model withSchema(Model m) {
        return ModelSpecFactory.withSpecSchema(m);
    }

    public static Resource findRootByType(Model m, Resource type) {
        StmtIterator it = m.listStatements(null, RDF.type, type);
        if (!it.hasNext()) {
            throw new BadDescriptionNoRootException(m, type);
        }
        Resource root = it.nextStatement().getSubject();
        if (it.hasNext()) {
            throw new BadDescriptionMultipleRootsException(m, type);
        }
        return root;
    }

    public static Resource findSpecificType(Resource root, Resource type) {
        StmtIterator it = root.listProperties(RDF.type);
        Model desc = root.getModel();
        while (it.hasNext()) {
            Resource candidate = it.nextStatement().getResource();
            if (!desc.contains(candidate, RDFS.subClassOf, type)) continue;
            type = candidate;
        }
        return type;
    }

    public static Model withSpecSchema(Model m) {
        Model result = ModelFactory.createDefaultModel();
        Model schema = JenaModelSpec.getSchema();
        result.add(m);
        ModelSpecFactory.addJMSSubclassesFrom(result, schema);
        ModelSpecFactory.addDomainTypes(result, m, schema);
        ModelSpecFactory.addSupertypesFrom(result, schema);
        ModelSpecFactory.addSupertypesFrom(result, m);
        return result;
    }

    protected static void addDomainTypes(Model result, Model m, Model schema) {
        StmtIterator it = schema.listStatements(null, RDFS.domain, nullObject);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Property property = (Property)s.getSubject().as(class$mx$com$hp$hpl$jena$rdf$model$Property == null ? ModelSpecFactory.class$("mx.com.hp.hpl.jena.rdf.model.Property") : class$mx$com$hp$hpl$jena$rdf$model$Property);
            StmtIterator x = m.listStatements(null, property, nullObject);
            while (x.hasNext()) {
                Statement t = x.nextStatement();
                result.add(t.getSubject(), RDF.type, s.getObject());
            }
        }
    }

    protected static void addJMSSubclassesFrom(Model result, Model schema) {
        StmtIterator it = schema.listStatements(null, RDFS.subClassOf, nullObject);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!s.getSubject().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#") || !s.getResource().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#")) continue;
            result.add(s);
        }
    }

    protected static void addSupertypesFrom(Model result, Model source) {
        Model temp = ModelFactory.createDefaultModel();
        StmtIterator it = result.listStatements(null, RDF.type, nullObject);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            StmtIterator subclasses = source.listStatements(s.getResource(), RDFS.subClassOf, nullObject);
            while (subclasses.hasNext()) {
                temp.add(s.getSubject(), RDF.type, subclasses.nextStatement().getObject());
            }
        }
        result.add(temp);
    }
}

