/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import java.util.HashMap;
import java.util.Map;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.ModelMaker;
import mx.com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import mx.com.hp.hpl.jena.rdf.model.ModelMakerCreatorRegistry;
import mx.com.hp.hpl.jena.rdf.model.ModelSpec;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.ResourceFactory;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import mx.com.hp.hpl.jena.util.FileManager;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;

public abstract class ModelSpecImpl
implements ModelSpec {
    protected ModelMaker maker;
    private static Map values = new HashMap();
    public static final Model emptyModel = ModelFactory.createDefaultModel();
    protected Model defaultModel = null;
    public static final Resource emptyResource = emptyModel.createResource();
    protected Model description = emptyModel;
    protected Resource root = ResourceFactory.createResource("");

    public ModelSpecImpl(ModelMaker maker) {
        if (maker == null) {
            throw new RuntimeException("null maker not allowed");
        }
        this.maker = maker;
    }

    public ModelSpecImpl(Resource root, Model description) {
        this(ModelSpecImpl.createMaker(ModelSpecImpl.getMaker(root, description), description));
        this.root = root;
        this.description = description;
    }

    public final Model createFreshModel() {
        return this.loadFiles(this.doCreateModel());
    }

    protected abstract Model doCreateModel();

    public Model createDefaultModel() {
        if (this.defaultModel == null) {
            this.defaultModel = this.makeDefaultModel();
        }
        return this.defaultModel;
    }

    protected Model makeDefaultModel() {
        Statement s = this.root.getProperty(JenaModelSpec.modelName);
        return this.loadFiles(s == null ? this.maker.createDefaultModel() : this.maker.createModel(s.getString()));
    }

    public Model createModelOver(String name) {
        return this.loadFiles(this.implementCreateModelOver(name));
    }

    public abstract Model implementCreateModelOver(String var1);

    public abstract Property getMakerProperty();

    public Model openModel(String name) {
        return this.loadFiles(this.maker.openModel(name));
    }

    public Model openModel() {
        Statement s = this.root.getProperty(JenaModelSpec.modelName);
        return this.loadFiles(s == null ? this.maker.openModel() : this.maker.openModel(s.getString(), true));
    }

    public Model openModelIfPresent(String name) {
        return this.maker.hasModel(name) ? this.loadFiles(this.maker.openModel(name)) : null;
    }

    public static Resource getMaker(Resource root, Model desc) {
        StmtIterator it = desc.listStatements(root, JenaModelSpec.maker, (RDFNode)null);
        if (it.hasNext()) {
            return it.nextStatement().getResource();
        }
        Resource r = desc.createResource();
        desc.add(root, JenaModelSpec.maker, r);
        return r;
    }

    public ModelMaker getModelMaker() {
        return this.maker;
    }

    public Model getDescription() {
        return this.getDescription(ResourceFactory.createResource());
    }

    public Model getDescription(Resource root) {
        return this.addDescription(ModelFactory.createDefaultModel(), root);
    }

    public Model addDescription(Model desc, Resource root) {
        Resource makerRoot = desc.createResource();
        desc.add(root, JenaModelSpec.maker, makerRoot);
        this.maker.addDescription(desc, makerRoot);
        return desc;
    }

    public static Resource createValue(Object value) {
        Resource it = ResourceFactory.createResource();
        values.put(it, value);
        return it;
    }

    public static Object getValue(RDFNode it) {
        return values.get(it);
    }

    public static Resource findRootByType(Model description, Resource type) {
        return ModelSpecFactory.findRootByType(ModelSpecFactory.withSchema(description), type);
    }

    public static ModelMaker createMaker(Model description) {
        Model d = ModelSpecFactory.withSchema(description);
        return ModelSpecImpl.createMakerByRoot(ModelSpecFactory.findRootByType(d, JenaModelSpec.MakerSpec), d);
    }

    public static ModelMaker createMaker(Resource root, Model d) {
        return ModelSpecImpl.createMakerByRoot(root, ModelSpecFactory.withSchema(d));
    }

    public static ModelMaker createMakerByRoot(Resource root, Model fullDesc) {
        Resource type = ModelSpecFactory.findSpecificType((Resource)root.inModel(fullDesc), JenaModelSpec.MakerSpec);
        ModelMakerCreator mmc = ModelMakerCreatorRegistry.findCreator(type);
        if (mmc == null) {
            throw new RuntimeException("no maker type");
        }
        return mmc.create(fullDesc, root);
    }

    public static Model readModel(Resource source) {
        String uri = source.getURI();
        return FileManager.get().loadModel(uri);
    }

    protected Model loadFiles(Model m) {
        StmtIterator it = this.description.listStatements(this.root, JenaModelSpec.loadWith, (RDFNode)null);
        while (it.hasNext()) {
            this.loadFile(m, it.nextStatement().getResource());
        }
        return m;
    }

    protected Model loadFile(Model m, Resource file) {
        FileManager.get().readModel(m, file.getURI());
        return m;
    }

    public Model getModel() {
        return this.createDefaultModel();
    }

    public Model createModel() {
        return this.createFreshModel();
    }
}

