/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import java.util.Properties;
import mx.com.hp.hpl.jena.JenaRuntime;
import mx.com.hp.hpl.jena.rdf.model.RDFReader;
import mx.com.hp.hpl.jena.rdf.model.RDFReaderF;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.NoReaderForLangException;

public class RDFReaderFImpl
implements RDFReaderF {
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N3", "TURTLE"};
    protected static final String[] DEFAULTREADERS = new String[]{"mx.com.hp.hpl.jena.rdf.arp.JenaReader", "mx.com.hp.hpl.jena.rdf.arp.JenaReader", "mx.com.hp.hpl.jena.rdf.model.impl.NTripleReader", "mx.com.hp.hpl.jena.rdf.model.impl.NTripleReader", "mx.com.hp.hpl.jena.n3.N3JenaReader", "mx.com.hp.hpl.jena.n3.TurtleJenaReader"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "mx.com.hp.hpl.jena.reader.";

    public RDFReader getReader() {
        return this.getReader(DEFAULTLANG);
    }

    public RDFReader getReader(String lang) {
        String className;
        if (lang == null || lang.equals("")) {
            lang = LANGS[0];
        }
        if ((className = langToClassName.getProperty(lang)) == null || className.equals("")) {
            throw new NoReaderForLangException(lang);
        }
        try {
            return (RDFReader)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    public String setReaderClassName(String lang, String className) {
        return RDFReaderFImpl.setBaseReaderClassName(lang, className);
    }

    public static String setBaseReaderClassName(String lang, String className) {
        String oldClassName = langToClassName.getProperty(lang);
        langToClassName.setProperty(lang, className);
        return oldClassName;
    }

    static {
        langToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            langToClassName.setProperty(LANGS[i], JenaRuntime.getSystemProperty(PROPNAMEBASE + LANGS[i], DEFAULTREADERS[i]));
        }
    }
}

