/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import java.util.Properties;
import mx.com.hp.hpl.jena.JenaRuntime;
import mx.com.hp.hpl.jena.rdf.model.RDFWriter;
import mx.com.hp.hpl.jena.rdf.model.RDFWriterF;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.NoWriterForLangException;

public class RDFWriterFImpl
implements RDFWriterF {
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N3", "N3-PP", "N3-PLAIN", "N3-TRIPLES", "N3-TRIPLE", "TURTLE"};
    protected static final String[] DEFAULTWRITERS = new String[]{"mx.com.hp.hpl.jena.xmloutput.impl.Basic", "mx.com.hp.hpl.jena.xmloutput.impl.Abbreviated", "mx.com.hp.hpl.jena.rdf.model.impl.NTripleWriter", "mx.com.hp.hpl.jena.rdf.model.impl.NTripleWriter", "mx.com.hp.hpl.jena.n3.N3JenaWriter", "mx.com.hp.hpl.jena.n3.N3JenaWriterPP", "mx.com.hp.hpl.jena.n3.N3JenaWriterPlain", "mx.com.hp.hpl.jena.n3.N3JenaWriterTriples", "mx.com.hp.hpl.jena.n3.N3JenaWriterTriples", "mx.com.hp.hpl.jena.n3.TurtleJenaWriter"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "mx.com.hp.hpl.jena.writer.";

    public RDFWriter getWriter() {
        return this.getWriter(DEFAULTLANG);
    }

    public RDFWriter getWriter(String lang) {
        String className;
        if (lang == null || lang.equals("")) {
            lang = LANGS[0];
        }
        if ((className = langToClassName.getProperty(lang)) == null || className.equals("")) {
            throw new NoWriterForLangException(lang);
        }
        try {
            return (RDFWriter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    public String setWriterClassName(String lang, String className) {
        String oldClassName = langToClassName.getProperty(lang);
        langToClassName.setProperty(lang, className);
        return oldClassName;
    }

    static {
        langToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            langToClassName.setProperty(LANGS[i], JenaRuntime.getSystemProperty(PROPNAMEBASE + LANGS[i], DEFAULTWRITERS[i]));
        }
    }
}

