/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.enhanced.Implementation;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Reifier;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.rdf.model.DoesNotReifyException;
import mx.com.hp.hpl.jena.rdf.model.ReifiedStatement;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelCom;
import mx.com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.StatementImpl;

public class ReifiedStatementImpl
extends ResourceImpl
implements ReifiedStatement {
    protected Statement statement;
    public static final Implementation reifiedStatementFactory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            Triple x = this.getTriple(eg, n);
            if (x == null) {
                throw new DoesNotReifyException(n);
            }
            Statement st = StatementImpl.toStatement(x, (ModelCom)eg);
            return new ReifiedStatementImpl(eg, n, st);
        }

        public boolean canWrap(Node n, EnhGraph eg) {
            return this.getTriple(eg, n) != null;
        }

        private Triple getTriple(EnhGraph eg, Node n) {
            return eg.asGraph().getReifier().getTriple(n);
        }
    };

    private ReifiedStatementImpl(ModelCom m, String uri, Statement s) {
        super(uri, m);
        this.assertStatement(s);
    }

    protected ReifiedStatementImpl(EnhGraph m, Node n, Statement s) {
        super(n, m);
        this.assertStatement(s);
    }

    private void assertStatement(Statement s) {
        this.statement = s;
    }

    public Statement getStatement() {
        return this.statement;
    }

    protected Reifier getReifier() {
        return this.getModel().getGraph().getReifier();
    }

    public boolean isValid() {
        return this.getModel().getGraph().getReifier().getTriple(this.asNode()) != null;
    }

    private ReifiedStatementImpl cache() {
        this.getReifier().reifyAs(this.asNode(), this.statement.asTriple());
        return this;
    }

    public static ReifiedStatement create(Statement s) {
        return ReifiedStatementImpl.create((ModelCom)s.getModel(), (String)null, s);
    }

    public static ReifiedStatementImpl create(ModelCom m, String uri, Statement s) {
        return new ReifiedStatementImpl(m, uri, s).cache();
    }

    public static ReifiedStatementImpl create(EnhGraph eg, Node n, Statement s) {
        return new ReifiedStatementImpl(eg, n, s).cache();
    }

    public String toString() {
        return super.toString() + "=>" + this.statement;
    }
}

