/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdf.model.impl;

import mx.com.hp.hpl.jena.enhanced.EnhGraph;
import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.enhanced.Implementation;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Alt;
import mx.com.hp.hpl.jena.rdf.model.Bag;
import mx.com.hp.hpl.jena.rdf.model.Container;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.NodeIterator;
import mx.com.hp.hpl.jena.rdf.model.ObjectF;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.ResourceF;
import mx.com.hp.hpl.jena.rdf.model.Seq;
import mx.com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.impl.ContainerImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelCom;
import mx.com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import mx.com.hp.hpl.jena.rdf.model.impl.SeqNodeIteratorFactoryImpl;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class SeqImpl
extends ContainerImpl
implements Seq {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node n, EnhGraph eg) {
            return true;
        }

        public EnhNode wrap(Node n, EnhGraph eg) {
            return new SeqImpl(n, eg);
        }
    };
    static NodeIteratorFactory seqIteratorFactory = new SeqNodeIteratorFactoryImpl();

    public SeqImpl(ModelCom model) {
        super(model);
    }

    public SeqImpl(String uri, ModelCom model) {
        super(uri, model);
    }

    public SeqImpl(Resource r, ModelCom m) {
        super(r, m);
    }

    public SeqImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public Resource getResource(int index) {
        return this.getRequiredProperty(RDF.li(index)).getResource();
    }

    public Literal getLiteral(int index) {
        return this.getRequiredProperty(RDF.li(index)).getLiteral();
    }

    public RDFNode getObject(int index) {
        return this.getRequiredProperty(RDF.li(index)).getObject();
    }

    public boolean getBoolean(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getBoolean();
    }

    public byte getByte(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getByte();
    }

    public short getShort(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getShort();
    }

    public int getInt(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getInt();
    }

    public long getLong(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getLong();
    }

    public char getChar(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getChar();
    }

    public float getFloat(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getFloat();
    }

    public double getDouble(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getDouble();
    }

    public String getString(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getString();
    }

    public String getLanguage(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getLanguage();
    }

    public Object getObject(int index, ObjectF f) {
        return this.getRequiredProperty(RDF.li(index)).getObject(f);
    }

    public Resource getResource(int index, ResourceF f) {
        return this.getRequiredProperty(RDF.li(index)).getResource(f);
    }

    public Bag getBag(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getBag();
    }

    public Alt getAlt(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getAlt();
    }

    public Seq getSeq(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getSeq();
    }

    public Seq set(int index, RDFNode o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq set(int index, boolean o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq set(int index, long o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq set(int index, float o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq set(int index, double o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq set(int index, char o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq set(int index, String o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq set(int index, String o, String l) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o, l);
        return this;
    }

    public Seq set(int index, Object o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    public Seq add(int index, boolean o) {
        return this.add(index, String.valueOf(o));
    }

    public Seq add(int index, long o) {
        return this.add(index, String.valueOf(o));
    }

    public Seq add(int index, char o) {
        return this.add(index, String.valueOf(o));
    }

    public Seq add(int index, float o) {
        return this.add(index, String.valueOf(o));
    }

    public Seq add(int index, double o) {
        return this.add(index, String.valueOf(o));
    }

    public Seq add(int index, Object o) {
        return this.add(index, String.valueOf(o));
    }

    public Seq add(int index, String o) {
        return this.add(index, o, "");
    }

    public Seq add(int index, String o, String l) {
        return this.add(index, this.literal(o, l));
    }

    public Seq add(int index, RDFNode o) {
        int size = this.size();
        this.checkIndex(index, size + 1);
        this.shiftUp(index, size);
        this.addProperty(RDF.li(index), o);
        return this;
    }

    public NodeIterator iterator() {
        return this.listContainerMembers(seqIteratorFactory);
    }

    public Container remove(Statement s) {
        this.getModel().remove(s);
        this.shiftDown(s.getPredicate().getOrdinal() + 1, this.size() + 1);
        return this;
    }

    public Seq remove(int index) {
        this.getRequiredProperty(RDF.li(index)).remove();
        this.shiftDown(index + 1, this.size() + 1);
        return this;
    }

    public Container remove(int index, RDFNode o) {
        return this.remove(this.getModel().createStatement((Resource)this, RDF.li(index), o).remove());
    }

    public int indexOf(RDFNode o) {
        return this.containerIndexOf(o);
    }

    public int indexOf(boolean o) {
        return this.indexOf(String.valueOf(o));
    }

    public int indexOf(long o) {
        return this.indexOf(String.valueOf(o));
    }

    public int indexOf(char o) {
        return this.indexOf(String.valueOf(o));
    }

    public int indexOf(float o) {
        return this.indexOf(String.valueOf(o));
    }

    public int indexOf(double o) {
        return this.indexOf(String.valueOf(o));
    }

    public int indexOf(Object o) {
        return this.indexOf(String.valueOf(o));
    }

    public int indexOf(String o) {
        return this.indexOf(o, "");
    }

    public int indexOf(String o, String l) {
        return this.indexOf(this.literal(o, l));
    }

    private Literal literal(String s, String lang) {
        return new LiteralImpl(Node.createLiteral(s, lang, false), this.getModelCom());
    }

    protected void shiftUp(int start, int finish) {
        Statement stmt = null;
        for (int i = finish; i >= start; --i) {
            stmt = this.getRequiredProperty(RDF.li(i));
            this.getModel().remove(stmt);
            this.addProperty(RDF.li(i + 1), stmt.getObject());
        }
    }

    protected void shiftDown(int start, int finish) {
        Statement stmt = null;
        for (int i = start; i <= finish; ++i) {
            stmt = this.getRequiredProperty(RDF.li(i));
            this.addProperty(RDF.li(i - 1), stmt.getObject());
            stmt.remove();
        }
    }

    protected void checkIndex(int index) {
        this.checkIndex(index, this.size());
    }

    protected void checkIndex(int index, int max) {
        if (1 > index || index > max) {
            throw new SeqIndexBoundsException(max, index);
        }
    }
}

