/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Node_ANY;
import mx.com.hp.hpl.jena.graph.Node_Literal;
import mx.com.hp.hpl.jena.graph.Node_URI;
import mx.com.hp.hpl.jena.graph.Node_Variable;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdql.Constraint;
import mx.com.hp.hpl.jena.rdql.QueryEngine;
import mx.com.hp.hpl.jena.rdql.QueryException;
import mx.com.hp.hpl.jena.rdql.QueryResults;
import mx.com.hp.hpl.jena.rdql.parser.Q_Query;
import mx.com.hp.hpl.jena.rdql.parser.RDQLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    static Log logger = LogFactory.getLog((Class)Query.class);
    protected List resultVars = new ArrayList();
    protected List patternVars = new ArrayList();
    protected List triplePatterns = new ArrayList();
    protected List constraints = new ArrayList();
    protected Map prefixMap = new HashMap();
    protected static Map defaultPrefixMap = new HashMap();
    String sourceURL = null;
    Model source = null;
    public long parseTime = -1L;
    public long buildTime = -1L;
    public long loadTime = -1L;
    public long executeTime = -1L;

    public Query(String s) {
        this();
        Q_Query query2 = null;
        try {
            this.parseTime = 0L;
            long startTime = 0L;
            StringReader in = new StringReader(s);
            startTime = System.currentTimeMillis();
            RDQLParser parser = new RDQLParser(in);
            parser.CompilationUnit();
            this.parseTime = System.currentTimeMillis() - startTime;
            logger.debug((Object)("Query parse time: " + this.parseTime));
            query2 = (Q_Query)parser.top();
            query2.phase2(this);
            this.buildTime = System.currentTimeMillis() - this.parseTime - startTime;
            logger.debug((Object)("Query parse and build time: " + this.buildTime));
        }
        catch (QueryException qEx) {
            throw qEx;
        }
        catch (Exception e) {
            throw new QueryException("Parse error: " + e);
        }
    }

    public Query() {
    }

    public static QueryResults exec(String queryString) {
        Query q = new Query(queryString);
        QueryEngine qe = new QueryEngine(q);
        qe.init();
        return qe.exec();
    }

    public static QueryResults exec(String queryString, Model model) {
        Query q = new Query(queryString);
        if (model != null) {
            q.setSource(model);
        }
        QueryEngine qe = new QueryEngine(q);
        qe.init();
        return qe.exec();
    }

    public static QueryResults exec(String queryString, String dataURL) {
        Query q = new Query(queryString);
        q.setSourceURL(dataURL);
        QueryEngine qe = new QueryEngine(q);
        qe.init();
        return qe.exec();
    }

    public void setSource(Model m) {
        this.source = m;
    }

    public Model getSource() {
        return this.source;
    }

    public void setSourceURL(String s) {
        this.sourceURL = s;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public void addResultVar(String varName) {
        if (!this.resultVars.contains(varName)) {
            this.resultVars.add(varName);
        }
    }

    public List getBoundVars() {
        return this.patternVars;
    }

    public void addBoundVar(String varName) {
        if (!this.patternVars.contains(varName)) {
            this.patternVars.add(varName);
        }
    }

    public void addConstraint(Constraint c) {
        this.constraints.add(c);
    }

    public List getConstraints() {
        return this.constraints;
    }

    public void addTriplePattern(Triple t) {
        this.triplePatterns.add(t);
    }

    public void addTriplePattern(Node s, Node p, Node o) {
        Triple t = new Triple(s, p, o);
        this.triplePatterns.add(t);
    }

    public List getTriplePatterns() {
        return this.triplePatterns;
    }

    public void setPrefix(String prefix, String expansion) {
        this.prefixMap.put(prefix, expansion);
    }

    public String getPrefix(String prefix) {
        String s = null;
        if (this.prefixMap != null) {
            s = (String)this.prefixMap.get(prefix);
        }
        if (s == null) {
            s = (String)defaultPrefixMap.get(prefix);
        }
        return s;
    }

    public Map getPrefixMap() {
        return this.prefixMap;
    }

    public Map getDefaultPrefixMap() {
        return defaultPrefixMap;
    }

    public String toString() {
        Iterator<Object> iter;
        boolean first;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT  ");
        if (this.resultVars.size() == 0) {
            sb.append("*");
        } else {
            first = true;
            iter = this.resultVars.iterator();
            while (iter.hasNext()) {
                String var = (String)iter.next();
                if (!first) {
                    sb.append(", ");
                }
                sb.append("?");
                sb.append(var);
                first = false;
            }
        }
        sb.append("\n");
        if (this.triplePatterns.size() > 0) {
            sb.append("WHERE   ");
            first = true;
            iter = this.triplePatterns.iterator();
            while (iter.hasNext()) {
                Triple tp = (Triple)iter.next();
                if (!first) {
                    sb.append(", \n");
                    sb.append("        ");
                }
                sb.append(this.triplePatternToString(tp));
                first = false;
            }
            sb.append("\n");
        }
        if (this.constraints.size() > 0) {
            Iterator iter2 = this.constraints.iterator();
            while (iter2.hasNext()) {
                Constraint c = (Constraint)iter2.next();
                sb.append("AND     ");
                sb.append(c.toString());
                sb.append("\n");
            }
        }
        if (this.prefixMap.size() > 0) {
            sb.append("USING\n");
            boolean first2 = true;
            iter = this.prefixMap.keySet().iterator();
            while (iter.hasNext()) {
                if (!first2) {
                    sb.append(" ,\n");
                }
                String k = (String)iter.next();
                String v = (String)this.prefixMap.get(k);
                sb.append("    " + k + " FOR <" + v + ">");
                first2 = false;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String triplePatternToString(Triple tp) {
        StringBuffer sb = new StringBuffer();
        sb.append("( ");
        sb.append(this.slotToString(tp.getSubject()));
        sb.append(", ");
        sb.append(this.slotToString(tp.getPredicate()));
        sb.append(", ");
        sb.append(this.slotToString(tp.getObject()));
        sb.append(" )");
        return sb.toString();
    }

    private String slotToString(Node n) {
        if (n instanceof Node_Variable) {
            return n.toString();
        }
        if (n instanceof Node_URI) {
            String s = this.applyPrefix(n.getURI());
            if (s == null) {
                return "<" + n.getURI() + ">";
            }
            return s;
        }
        if (n instanceof Node_Literal) {
            String language = n.getLiteralLanguage();
            String typeURI = n.getLiteralDatatypeURI();
            StringBuffer sb = new StringBuffer();
            sb.append('\"');
            sb.append(n.getLiteralLexicalForm());
            sb.append('\"');
            if (language != null && language.length() > 0) {
                sb.append("@");
                sb.append(language);
            }
            if (typeURI != null) {
                sb.append("^^<");
                sb.append(typeURI);
                sb.append(">");
            }
            return sb.toString();
        }
        if (n instanceof Node_ANY) {
            return "any:" + n;
        }
        return "unknown:" + n;
    }

    private String applyPrefix(String uri) {
        String s = this.applyPrefix(uri, this.prefixMap, null);
        if (s == null) {
            s = this.applyPrefix(uri, defaultPrefixMap, this.prefixMap);
        }
        return s;
    }

    private String applyPrefix(String uri, Map pm, Map exclude) {
        Iterator it = pm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String ss = (String)e.getValue();
            if (!uri.startsWith(ss) || exclude != null && exclude.containsKey(e.getKey()) && !exclude.get(e.getKey()).equals(e.getValue())) continue;
            return e.getKey() + ":" + uri.substring(ss.length());
        }
        return null;
    }

    static {
        defaultPrefixMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        defaultPrefixMap.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        defaultPrefixMap.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultPrefixMap.put("owl", "http://www.w3.org/2002/07/owl#");
    }
}

