/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql;

import java.io.PrintWriter;
import java.util.Iterator;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdql.QueryResults;
import mx.com.hp.hpl.jena.rdql.QueryResultsMem;
import mx.com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import mx.com.hp.hpl.jena.rdql.ResultBinding;
import mx.com.hp.hpl.jena.rdql.ResultBindingIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.ResultSet;

public class QueryResultsFormatter {
    QueryResults queryResults;
    QueryResultsMem all = null;
    int numRows = -2;
    int numCols = -2;
    int[] colWidths = null;
    static final String notThere = "<<unset>>";
    public static final String resultsNamespace = "http://jena.hpl.hp.com/2003/03/queryResults#";

    public QueryResultsFormatter(QueryResults qresults) {
        this.queryResults = qresults;
    }

    public int numColumns() {
        return this.queryResults.getResultVars().size();
    }

    public int numRows() {
        return this.numRows;
    }

    private void colWidths() {
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        this.numCols = this.queryResults.getResultVars().size();
        this.numRows = 0;
        this.colWidths = new int[this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            this.colWidths[i] = ((String)this.queryResults.getResultVars().get(i)).length();
        }
        while (this.all.hasNext()) {
            ++this.numRows;
            ResultBinding env = (ResultBinding)this.all.next();
            int col = -1;
            Iterator iter = this.queryResults.getResultVars().iterator();
            while (iter.hasNext()) {
                String rVar = (String)iter.next();
                String s = this.getVarAsString(env, rVar);
                if (this.colWidths[++col] >= s.length()) continue;
                this.colWidths[col] = s.length();
            }
        }
        this.all.reset();
    }

    public void close() {
        this.queryResults.close();
        this.queryResults = null;
        this.all = null;
        this.colWidths = null;
    }

    public Model toModel() {
        Model m = ModelFactory.createDefaultModel();
        this.asRDF(m);
        return m;
    }

    public Resource asRDF(Model model) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, ResultSet.ResultSet);
        Iterator iter = this.queryResults.getResultVars().iterator();
        while (iter.hasNext()) {
            String vName = (String)iter.next();
            results.addProperty(ResultSet.resultVariable, vName);
        }
        int count = 0;
        QueryResults solutionsIter = this.queryResults;
        while (solutionsIter.hasNext()) {
            ++count;
            ResultBinding env = (ResultBinding)solutionsIter.next();
            Resource thisSolution = model.createResource();
            results.addProperty(ResultSet.solution, thisSolution);
            Iterator iter2 = this.queryResults.getResultVars().iterator();
            while (iter2.hasNext()) {
                Resource thisBinding = model.createResource();
                String rVar = (String)iter2.next();
                Object tmp = env.get(rVar);
                RDFNode n = null;
                if (tmp == null) {
                    n = ResultSet.undefined;
                } else {
                    if (!(tmp instanceof RDFNode)) {
                        System.err.println("Class wrong: " + tmp.getClass().getName());
                        continue;
                    }
                    n = (RDFNode)env.get(rVar);
                }
                thisBinding.addProperty(ResultSet.variable, rVar);
                thisBinding.addProperty(ResultSet.value, n);
                thisSolution.addProperty(ResultSet.binding, thisBinding);
            }
        }
        results.addProperty(ResultSet.size, count);
        return results;
    }

    public void dump(PrintWriter pw, boolean format) {
        if (this.queryResults.getResultVars().size() == 0) {
            pw.println("# ==== No variables ====");
            pw.flush();
            return;
        }
        pw.println("# Variables:");
        Iterator iter = this.queryResults.getResultVars().iterator();
        while (iter.hasNext()) {
            String vName = (String)iter.next();
            pw.print("?" + vName + " ");
        }
        pw.println(".");
        pw.println("# Data:");
        pw.flush();
        if (format) {
            this.dumpAligned(pw);
        } else {
            this.dumpRaw(pw);
        }
    }

    private void dumpRaw(PrintWriter pw) {
        this.numCols = this.queryResults.getResultVars().size();
        QueryResults tableIter = this.queryResults;
        while (tableIter.hasNext()) {
            ResultBinding env = (ResultBinding)tableIter.next();
            Iterator iter = this.queryResults.getResultVars().iterator();
            while (iter.hasNext()) {
                String rVar = (String)iter.next();
                String s = this.getVarAsString(env, rVar);
                pw.print("?");
                pw.print(rVar);
                pw.print(" ");
                pw.print(s);
                pw.print(" ");
            }
            pw.println(".");
        }
        this.queryResults.close();
    }

    private void dumpAligned(PrintWriter pw) {
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] row = new String[this.numCols];
        int lineWidth = 0;
        for (int col = 0; col < this.numCols; ++col) {
            String rVar;
            row[col] = rVar = (String)this.queryResults.getResultVars().get(col);
            lineWidth += this.colWidths[col];
        }
        QueryResultsMem tableIter = this.all;
        while (tableIter.hasNext()) {
            ResultBinding env = (ResultBinding)tableIter.next();
            for (int col = 0; col < this.numCols; ++col) {
                StringBuffer sbuff = new StringBuffer(120);
                String rVar = (String)this.queryResults.getResultVars().get(col);
                sbuff.append('?');
                sbuff.append(rVar);
                sbuff.append(' ');
                String s = this.getVarAsString(env, rVar);
                int pad = this.colWidths[col];
                sbuff.append(s);
                for (int j = 0; j < pad - s.length(); ++j) {
                    sbuff.append(' ');
                }
                sbuff.append(' ');
                pw.print(sbuff);
            }
            pw.println(" .");
        }
        this.all.close();
        pw.flush();
    }

    public void printAll(PrintWriter printwriter) {
        this.printAll(printwriter, " | ", null);
    }

    public void printAll(PrintWriter printwriter, String colSep) {
        this.printAll(printwriter, colSep, null);
    }

    public void printAll(PrintWriter printwriter, String colSep, String lineEnd) {
        if (this.queryResults.getResultVars().size() == 0) {
            printwriter.println("==== No variables ====");
            printwriter.flush();
            return;
        }
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] row = new String[this.numCols];
        int lineWidth = 0;
        for (int col = 0; col < this.numCols; ++col) {
            String rVar;
            row[col] = rVar = (String)this.queryResults.getResultVars().get(col);
            lineWidth += this.colWidths[col];
            if (col <= 0) continue;
            lineWidth += colSep.length();
        }
        this.printRow(printwriter, row, colSep, lineEnd);
        for (int i = 0; i < lineWidth; ++i) {
            printwriter.print('=');
        }
        printwriter.println();
        QueryResultsMem tableIter = this.all;
        while (tableIter.hasNext()) {
            ResultBinding env = (ResultBinding)tableIter.next();
            for (int col = 0; col < this.numCols; ++col) {
                String rVar = (String)this.queryResults.getResultVars().get(col);
                row[col] = this.getVarAsString(env, rVar);
            }
            this.printRow(printwriter, row, colSep, lineEnd);
        }
        this.all.reset();
        printwriter.flush();
    }

    private void printRow(PrintWriter pw, String[] row, String colSep, String lineEnd) {
        if (row.length != this.numCols) {
            throw new RDQL_InternalErrorException("QueryResultsFormatter.printRow: Row length (" + row.length + ") != numCols (" + this.numCols + ")");
        }
        for (int col = 0; col < this.numCols; ++col) {
            String s = row[col];
            int pad = this.colWidths[col];
            StringBuffer sbuff = new StringBuffer(120);
            if (col > 0) {
                sbuff.append(colSep);
            }
            sbuff.append(s);
            for (int j = 0; j < pad - s.length(); ++j) {
                sbuff.append(' ');
            }
            pw.print(sbuff);
        }
        if (lineEnd != null) {
            pw.print(lineEnd);
        }
        pw.println();
    }

    public void printHTML(PrintWriter pw) {
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
            this.numRows = this.all.size();
        }
        pw.println("<table>");
        pw.println("  <tr>");
        for (int ii = 0; ii < this.queryResults.getResultVars().size(); ++ii) {
            String tmp = (String)this.queryResults.getResultVars().get(ii);
            pw.print("    <th>");
            pw.print(tmp);
            pw.print("</th>");
            pw.println();
        }
        pw.println("  </tr>");
        while (this.all.hasNext()) {
            pw.println("  <tr>");
            ResultBinding env = (ResultBinding)this.all.next();
            for (int col = 0; col < this.queryResults.getResultVars().size(); ++col) {
                String rVar = (String)this.queryResults.getResultVars().get(col);
                RDFNode val = (RDFNode)env.get(rVar);
                String s = val == null ? notThere : ((Object)val).toString();
                pw.print("    <td>");
                pw.print(s);
                pw.print("</td>");
                pw.println();
            }
            pw.println("  </tr>");
        }
        pw.println("</table>");
        pw.flush();
        this.all.reset();
    }

    public void consume() {
        QueryResults rowIter = this.queryResults;
        while (rowIter.hasNext()) {
            ResultBinding result = (ResultBinding)rowIter.next();
            ResultBindingIterator iter = result.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
        }
    }

    private String getVarAsString(ResultBinding env, String varName) {
        Object obj = env.get(varName);
        if (obj != null) {
            if (!(obj instanceof RDFNode)) {
                return "Found a " + obj.getClass().getName();
            }
            if (obj instanceof Literal) {
                Literal l = (Literal)obj;
                StringBuffer sb = new StringBuffer();
                sb.append('\"').append(l.getLexicalForm()).append('\"');
                if (!l.getLanguage().equals("")) {
                    sb.append("@").append(l.getLanguage());
                }
                if (l.getDatatype() != null) {
                    sb.append("^^<").append(l.getDatatypeURI()).append(">");
                }
                return sb.toString();
            }
            if (obj instanceof Resource) {
                Resource r = (Resource)obj;
                if (r.isAnon()) {
                    return "anon:" + r.getId();
                }
                return "<" + r.getURI() + ">";
            }
        }
        return notThere;
    }
}

