/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.rdql.QueryResults;
import mx.com.hp.hpl.jena.rdql.QueryResultsFormatter;
import mx.com.hp.hpl.jena.rdql.QueryResultsRewindable;
import mx.com.hp.hpl.jena.rdql.ResultBinding;
import mx.com.hp.hpl.jena.rdql.ResultBindingImpl;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.util.FileManager;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.ResultSet;

public class QueryResultsMem
implements QueryResultsRewindable {
    static final boolean DEBUG = false;
    List rows = new ArrayList();
    List varNames = null;
    int rowNumber = 0;
    Iterator iterator = null;

    public QueryResultsMem(QueryResultsMem imrs2) {
        this(imrs2, false);
    }

    public QueryResultsMem(QueryResultsMem imrs2, boolean takeCopy) {
        this.varNames = imrs2.varNames;
        if (takeCopy) {
            Iterator iter = imrs2.rows.iterator();
            while (iter.hasNext()) {
                this.rows.add((ResultBinding)iter.next());
            }
        } else {
            this.rows = imrs2.rows;
        }
        this.reset();
    }

    public QueryResultsMem(QueryResults qr) {
        if (qr instanceof QueryResultsMem) {
            QueryResultsMem qrm = (QueryResultsMem)qr;
            this.rows = qrm.rows;
            this.varNames = qrm.varNames;
        } else {
            this.varNames = qr.getResultVars();
            while (qr.hasNext()) {
                ResultBinding rb = (ResultBinding)qr.next();
                this.rows.add(rb);
            }
            qr.close();
        }
        this.reset();
    }

    public QueryResultsMem(Model model) {
        this.buildFromDumpFormat(model);
    }

    public QueryResultsMem(String urlStr) throws FileNotFoundException {
        Model m = FileManager.get().loadModel(urlStr);
        this.buildFromDumpFormat(m);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("QueryResultsMem: Attempt to remove an element");
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        ++this.rowNumber;
        return this.iterator.next();
    }

    public void close() {
        this.iterator = null;
        this.varNames = null;
    }

    public void rewind() {
        this.reset();
    }

    public void reset() {
        this.iterator = this.rows.iterator();
        this.rowNumber = 0;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int size() {
        return this.rows.size();
    }

    public List getResultVars() {
        return this.varNames;
    }

    public List getAll() {
        return this.rows;
    }

    private void buildFromDumpFormat(Model resultsModel) {
        this.varNames = new ArrayList();
        StmtIterator sIter = resultsModel.listStatements(null, RDF.type, ResultSet.ResultSet);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            Resource root = s.getSubject();
            StmtIterator rVarsIter = root.listProperties(ResultSet.resultVariable);
            while (rVarsIter.hasNext()) {
                String varName = rVarsIter.nextStatement().getString();
                this.varNames.add(varName);
            }
            rVarsIter.close();
            int count = 0;
            StmtIterator solnIter = root.listProperties(ResultSet.solution);
            while (solnIter.hasNext()) {
                ResultBindingImpl rb = new ResultBindingImpl();
                ++count;
                Resource soln = solnIter.nextStatement().getResource();
                StmtIterator bindingIter = soln.listProperties(ResultSet.binding);
                while (bindingIter.hasNext()) {
                    Resource binding = bindingIter.nextStatement().getResource();
                    String var = binding.getRequiredProperty(ResultSet.variable).getString();
                    RDFNode val = binding.getRequiredProperty(ResultSet.value).getObject();
                    rb.add(var, val);
                }
                bindingIter.close();
                this.rows.add(rb);
            }
            solnIter.close();
            if (root.hasProperty(ResultSet.size)) {
                try {
                    int size = root.getRequiredProperty(ResultSet.size).getInt();
                    if (size != count) {
                        System.err.println("Warning: Declared size = " + size + " : Count = " + count);
                    }
                }
                catch (JenaException rdfEx) {
                    // empty catch block
                }
            }
            sIter.close();
        }
        this.reset();
    }

    public static boolean equivalent(QueryResultsMem irs1, QueryResultsMem irs2) {
        QueryResultsFormatter fmt1 = new QueryResultsFormatter(irs1);
        Model model1 = fmt1.toModel();
        QueryResultsFormatter fmt2 = new QueryResultsFormatter(irs2);
        Model model2 = fmt2.toModel();
        return model1.isIsomorphicWith(model2);
    }

    public Model toModel() {
        Model m = ModelFactory.createDefaultModel();
        this.asRDF(m);
        return m;
    }

    public Resource asRDF(Model model) {
        QueryResultsFormatter fmt = new QueryResultsFormatter(this);
        Resource r = fmt.asRDF(model);
        fmt.close();
        return r;
    }

    public void list(PrintWriter pw) {
        QueryResultsMem qrm = new QueryResultsMem(this);
        QueryResultsFormatter fmt = new QueryResultsFormatter(qrm);
        fmt.dump(pw, false);
        qrm.close();
    }
}

