/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.QueryExecution;
import mx.com.hp.hpl.jena.rdql.QueryResults;
import mx.com.hp.hpl.jena.rdql.ResultBinding;

public class QueryResultsStream
implements QueryResults {
    Iterator queryExecutionIter;
    QueryExecution queryExecution;
    List resultVars;
    ResultBinding currentEnv;
    int rowNumber;
    volatile boolean finished = false;

    public QueryResultsStream(Query query2, QueryExecution qe, Iterator iter) {
        this.queryExecutionIter = iter;
        this.queryExecution = qe;
        this.resultVars = query2.getResultVars();
        this.currentEnv = null;
        this.rowNumber = 0;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("com.hp.hpl.jena.rdf.query.QueryResults.remove");
    }

    public boolean hasNext() {
        return this.queryExecutionIter.hasNext();
    }

    public Object next() {
        this.currentEnv = (ResultBinding)this.queryExecutionIter.next();
        if (this.currentEnv != null) {
            ++this.rowNumber;
        }
        return this.currentEnv;
    }

    public void close() {
        if (!this.finished) {
            this.queryExecution.abort();
            this.finished = true;
        } else {
            this.queryExecution.close();
        }
    }

    public String getBinding(String name) {
        return this.getBindingWorker(name, false);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public List getAll() {
        ArrayList<Object> all = new ArrayList<Object>();
        while (this.hasNext()) {
            all.add(this.next());
        }
        this.close();
        return all;
    }

    private String getBindingWorker(String name, boolean projectResultVars) {
        if (!projectResultVars || this.resultVars.contains(name)) {
            Object v = this.currentEnv.get(name);
            if (v == null) {
                return null;
            }
            return v.toString();
        }
        return null;
    }
}

