/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql.parser;

import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.graph.query.Valuator;
import mx.com.hp.hpl.jena.graph.query.VariableIndexes;
import mx.com.hp.hpl.jena.rdql.Constraint;
import mx.com.hp.hpl.jena.rdql.EvalFailureException;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.parser.Expr;
import mx.com.hp.hpl.jena.rdql.parser.Node;
import mx.com.hp.hpl.jena.rdql.parser.NodeValue;
import mx.com.hp.hpl.jena.rdql.parser.RDQLParser;
import mx.com.hp.hpl.jena.rdql.parser.SimpleNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class ExprNode
extends SimpleNode
implements Expression,
Valuator,
Constraint,
Expr {
    static Log log = LogFactory.getLog((Class)ExprNode.class);
    Query query;
    VariableIndexes varIndexes;
    static final String exprBaseURI = "urn:x-jena:expr:";

    public ExprNode(RDQLParser p, int i) {
        super(p, i);
    }

    public ExprNode(int i) {
        super(i);
    }

    public boolean isSatisfied(Query q, IndexValues env) {
        return this.evalBool(q, env);
    }

    public void postParse(Query q) {
        super.postParse(q);
        this.query = q;
    }

    public Valuator prepare(VariableIndexes vi) {
        this.varIndexes = vi;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Node n = this.children[i];
                if (!(n instanceof Expression)) continue;
                ((Expression)((Object)n)).prepare(vi);
            }
        }
        return this;
    }

    public Object evalObject(IndexValues iv) {
        return this.evalNode(this.query, iv);
    }

    public boolean evalBool(IndexValues iv) {
        return this.evalBool(this.query, iv);
    }

    protected boolean evalBool(Query q, IndexValues iv) {
        NodeValue v = this.evalNode(q, iv);
        return v == null ? false : v.getBoolean();
    }

    public NodeValue evalNode(Query q, IndexValues env) {
        try {
            return this.eval(q, env);
        }
        catch (EvalFailureException e) {
            return null;
        }
        catch (Exception e) {
            log.warn((Object)"RDQL : general exception!", (Throwable)e);
            return null;
        }
    }

    public boolean isVariable() {
        return false;
    }

    public String getName() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public boolean isApply() {
        return false;
    }

    public String getFun() {
        return null;
    }

    public int argCount() {
        return 0;
    }

    public Expression getArg(int i) {
        return null;
    }

    protected String constructURI(String className) {
        if (className.lastIndexOf(46) > -1) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        return exprBaseURI + className;
    }

    public String toString() {
        return this.asInfixString();
    }
}

