/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql.parser;

import java.io.PrintWriter;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.rdql.EvalTypeException;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.QueryException;
import mx.com.hp.hpl.jena.rdql.QueryPrintUtils;
import mx.com.hp.hpl.jena.rdql.parser.Expr;
import mx.com.hp.hpl.jena.rdql.parser.ExprNode;
import mx.com.hp.hpl.jena.rdql.parser.ExprNumeric;
import mx.com.hp.hpl.jena.rdql.parser.NodeValue;
import mx.com.hp.hpl.jena.rdql.parser.NodeValueSettable;
import mx.com.hp.hpl.jena.rdql.parser.RDQLParser;
import mx.com.hp.hpl.jena.rdql.parser.WorkingVar;

public class Q_Modulus
extends ExprNode
implements Expr,
ExprNumeric {
    Expr left;
    Expr right;
    private String printName = "mod";
    private String opSymbol = "%";

    Q_Modulus(int id) {
        super(id);
    }

    Q_Modulus(RDQLParser p, int id) {
        super(p, id);
    }

    public NodeValue eval(Query q, IndexValues env) {
        NodeValue x = this.left.eval(q, env);
        NodeValue y = this.right.eval(q, env);
        if (!x.isNumber()) {
            throw new EvalTypeException("Q_Modulus: Wanted a number: " + x);
        }
        if (!y.isNumber()) {
            throw new EvalTypeException("Q_Modulus: Wanted a number: " + y);
        }
        NodeValueSettable result = x instanceof NodeValueSettable ? (NodeValueSettable)x : (y instanceof NodeValueSettable ? (NodeValueSettable)y : new WorkingVar());
        if (x.isInt() && y.isInt()) {
            result.setInt(x.getInt() % y.getInt());
        } else {
            result.setDouble(x.getDouble() % y.getDouble());
        }
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_Modulus: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (i == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter pw, int level) {
        QueryPrintUtils.print(pw, this.left, this.right, this.printName, this.opSymbol, level);
    }

    public String toString() {
        return this.asInfixString();
    }
}

