/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql.parser;

import java.io.PrintWriter;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.graph.query.PatternLiteral;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import mx.com.hp.hpl.jena.rdql.parser.Expr;
import mx.com.hp.hpl.jena.rdql.parser.ExprNode;
import mx.com.hp.hpl.jena.rdql.parser.NodeValue;
import mx.com.hp.hpl.jena.rdql.parser.RDQLParser;

public class Q_PatternLiteral
extends ExprNode
implements Expr,
PatternLiteral {
    String patternString = null;
    String modifiers = "";
    int mask;

    Q_PatternLiteral(int id) {
        super(id);
    }

    Q_PatternLiteral(RDQLParser p, int id) {
        super(p, id);
    }

    public void setPattern(String str) {
        this.patternString = str;
    }

    public void setModifiers(String str) {
        this.modifiers = this.modifiers + str;
        block6: for (int i = 0; i < this.modifiers.length(); ++i) {
            switch (this.modifiers.charAt(i)) {
                case 'i': {
                    this.mask |= 1;
                    continue block6;
                }
                case 'm': {
                    this.mask |= 8;
                    continue block6;
                }
                case 's': {
                    this.mask |= 0x10;
                    continue block6;
                }
                case 'x': {
                    this.mask |= 0x20;
                }
            }
        }
    }

    public String toString() {
        if (this.patternString.indexOf(47) == -1) {
            return "/" + this.patternString + "/" + this.modifiers;
        }
        if (this.patternString.indexOf(33) == -1) {
            return "m!" + this.patternString + "!" + this.modifiers;
        }
        if (this.patternString.indexOf(37) == -1) {
            return "m%" + this.patternString + "%" + this.modifiers;
        }
        char marker = '!';
        return "m" + marker + this.quote(this.patternString, marker) + marker + this.modifiers;
    }

    private String quote(String pString, char marker) {
        int j;
        int i = 0;
        while ((j = pString.indexOf(marker, i)) != -1) {
            pString = pString.substring(0, j) + "\\" + pString.substring(j);
            i = j + 2;
        }
        return pString;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public boolean isConstant() {
        return true;
    }

    public Object getValue() {
        return this.toString();
    }

    public void print(PrintWriter pw, int level) {
        pw.print(this.toString());
    }

    public NodeValue eval(Query q, IndexValues env) {
        throw new RDQL_InternalErrorException("Q_PatternLiteral.eval called!");
    }

    public String asPrefixString() {
        return this.toString();
    }

    public String asInfixString() {
        return this.toString();
    }

    public String getPatternModifiers() {
        return this.modifiers == null ? "" : this.modifiers;
    }

    public String getPatternLanguage() {
        return "http://jena.hpl.hp.com/2003/07/query/RDQL";
    }
}

