/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql.parser;

import java.io.PrintWriter;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.rdql.EvalFailureException;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.QueryException;
import mx.com.hp.hpl.jena.rdql.QueryPrintUtils;
import mx.com.hp.hpl.jena.rdql.parser.Expr;
import mx.com.hp.hpl.jena.rdql.parser.ExprBoolean;
import mx.com.hp.hpl.jena.rdql.parser.ExprNode;
import mx.com.hp.hpl.jena.rdql.parser.NodeValue;
import mx.com.hp.hpl.jena.rdql.parser.Q_PatternLiteral;
import mx.com.hp.hpl.jena.rdql.parser.RDQLParser;
import mx.com.hp.hpl.jena.rdql.parser.WorkingVar;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Q_StringMatch
extends ExprNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    Q_PatternLiteral regex = null;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();
    private String printName = "strMatch";
    private String opSymbol = "=~";
    Pattern pattern = null;

    Q_StringMatch(int id) {
        super(id);
    }

    Q_StringMatch(RDQLParser p, int id) {
        super(p, id);
    }

    public NodeValue eval(Query q, IndexValues env) {
        NodeValue x = this.left.eval(q, env);
        String xx = x.valueString();
        WorkingVar result = new WorkingVar();
        boolean b = this.matcher.contains(xx, this.pattern);
        result.setBoolean(b);
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringMatch: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
        if (!(this.right instanceof Q_PatternLiteral)) {
            throw new EvalFailureException("Q_StringMatch: Pattern error");
        }
        this.regex = (Q_PatternLiteral)this.right;
        try {
            this.pattern = this.compiler.compile(this.regex.patternString, this.regex.mask);
        }
        catch (MalformedPatternException pEx) {
            throw new EvalFailureException("Q_StringMatch: Pattern exception: " + (Object)((Object)pEx));
        }
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (i == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter pw, int level) {
        QueryPrintUtils.print(pw, this.left, this.right, this.printName, this.opSymbol, level);
    }

    public String toString() {
        return this.asInfixString();
    }
}

