/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.rdql.parser;

import java.io.PrintWriter;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.rdql.EvalTypeException;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.QueryException;
import mx.com.hp.hpl.jena.rdql.QueryPrintUtils;
import mx.com.hp.hpl.jena.rdql.parser.Expr;
import mx.com.hp.hpl.jena.rdql.parser.ExprNode;
import mx.com.hp.hpl.jena.rdql.parser.ExprNumeric;
import mx.com.hp.hpl.jena.rdql.parser.NodeValue;
import mx.com.hp.hpl.jena.rdql.parser.RDQLParser;
import mx.com.hp.hpl.jena.rdql.parser.WorkingVar;

public class Q_UnaryMinus
extends ExprNode
implements ExprNumeric {
    Expr expr;
    private String printName = "unaryminus";
    private String opSymbol = "-";

    Q_UnaryMinus(int id) {
        super(id);
    }

    Q_UnaryMinus(RDQLParser p, int id) {
        super(p, id);
    }

    public NodeValue eval(Query q, IndexValues env) {
        NodeValue v = this.expr.eval(q, env);
        if (!v.isNumber()) {
            throw new EvalTypeException("Q_UnaryMinus: Wanted a number: got " + this.expr);
        }
        WorkingVar result = new WorkingVar();
        if (v.isInt()) {
            result.setInt(-v.getInt());
        } else {
            result.setDouble(-v.getDouble());
        }
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryMinus: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 1;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.expr instanceof Expression) {
            return (Expression)((Object)this.expr);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void print(PrintWriter pw, int level) {
        QueryPrintUtils.print(pw, this.expr, null, this.printName, this.opSymbol, level);
    }

    public String toString() {
        return this.asInfixString();
    }
}

