/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner;

import mx.com.hp.hpl.jena.reasoner.FGraph;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class FinderUtil {
    public static Finder cascade(Finder first, Finder second) {
        if (first == null || first instanceof FGraph && ((FGraph)first).getGraph() == null) {
            return second;
        }
        if (second == null || second instanceof FGraph && ((FGraph)second).getGraph() == null) {
            return first;
        }
        return new Cascade(first, second);
    }

    public static Finder cascade(Finder first, Finder second, Finder third) {
        return new Cascade(first, FinderUtil.cascade(second, third));
    }

    public static Finder cascade(Finder first, Finder second, Finder third, Finder fourth) {
        return new Cascade(first, FinderUtil.cascade(second, FinderUtil.cascade(third, fourth)));
    }

    private static class Cascade
    implements Finder {
        Finder first;
        Finder second;

        Cascade(Finder first, Finder second) {
            this.first = first;
            this.second = second;
        }

        public ExtendedIterator find(TriplePattern pattern) {
            if (this.second == null) {
                return this.first.find(pattern);
            }
            if (this.first == null) {
                return this.second.find(pattern);
            }
            return this.first.findWithContinuation(pattern, this.second);
        }

        public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
            return FinderUtil.cascade(this.first, this.second, continuation).find(pattern);
        }

        public boolean contains(TriplePattern pattern) {
            ExtendedIterator it = this.find(pattern);
            boolean result = it.hasNext();
            it.close();
            return result;
        }
    }
}

