/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import java.util.ArrayList;
import java.util.List;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnection;

public class DIGConnectionPool {
    private static DIGConnectionPool s_instance = new DIGConnectionPool();
    private List m_pool = new ArrayList();
    private List m_allocated = new ArrayList();

    private DIGConnectionPool() {
    }

    public static DIGConnectionPool getInstance() {
        return s_instance;
    }

    public DIGConnection allocate() {
        DIGConnection dc = this.m_pool.isEmpty() ? new DIGConnection() : (DIGConnection)this.m_pool.remove(0);
        this.m_allocated.add(dc);
        return dc;
    }

    public DIGConnection allocate(String connectionURL) {
        for (int i = 0; i < this.m_pool.size(); ++i) {
            DIGConnection c = (DIGConnection)this.m_pool.get(i);
            if (!connectionURL.equals(c.getReasonerURL())) continue;
            this.m_pool.remove(i);
            this.m_allocated.add(c);
            return c;
        }
        DIGConnection dc = this.m_pool.isEmpty() ? new DIGConnection() : (DIGConnection)this.m_pool.remove(0);
        this.m_allocated.add(dc);
        dc.setReasonerURL(connectionURL);
        return dc;
    }

    public void release(DIGConnection dc) {
        this.m_allocated.remove(dc);
        this.m_pool.add(dc);
    }
}

