/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.compose.MultiUnion;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.Profile;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.FGraph;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.StandardValidityReport;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.ValidityReport;
import mx.com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnection;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import mx.com.hp.hpl.jena.reasoner.dig.DIGErrorResponseException;
import mx.com.hp.hpl.jena.reasoner.dig.DIGInconsistentKBException;
import mx.com.hp.hpl.jena.reasoner.dig.DIGQueryEquivalentsTranslator;
import mx.com.hp.hpl.jena.reasoner.dig.DIGQueryTypesTranslator;
import mx.com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import mx.com.hp.hpl.jena.reasoner.dig.DIGValueToNodeMapper;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class DIGInfGraph
extends BaseInfGraph {
    protected DIGAdapter m_adapter;

    public DIGInfGraph(Graph data, DIGReasoner reasoner) {
        super(data, reasoner);
        if (reasoner.getSchema() != null) {
            this.fdata = new FGraph(new MultiUnion(new Graph[]{data, reasoner.getSchema()}));
        }
        DIGConnection conn = DIGConnectionPool.getInstance().allocate(reasoner.getReasonerURL());
        this.m_adapter = new DIGAdapter(reasoner.getOntLangModelSpec(), this.fdata.getGraph(), conn, reasoner.getAxioms());
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.m_adapter.resetKB();
            this.m_adapter.uploadKB();
            this.isPrepared = true;
        }
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.prepare();
        return this.m_adapter.find(pattern);
    }

    public ExtendedIterator find(Node subject, Node property, Node object, Graph param) {
        OntModel premises = ModelFactory.createOntologyModel(this.m_adapter.getSourceSpecification(), ModelFactory.createModelForGraph(param));
        premises.setStrictMode(false);
        this.prepare();
        return this.m_adapter.find(new TriplePattern(subject, property, object), premises);
    }

    public Graph getSchemaGraph() {
        return ((DIGReasoner)this.reasoner).getSchema();
    }

    public synchronized void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        this.isPrepared = false;
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        this.isPrepared = false;
    }

    public void rebind(Graph data) {
        this.fdata = this.getSchemaGraph() == null ? new FGraph(data) : new FGraph(new MultiUnion(new Graph[]{data, this.getSchemaGraph()}));
        this.isPrepared = false;
    }

    public void setDerivationLogging(boolean logOn) {
        throw new UnsupportedOperationException("Cannot set derivation logging on DIG reasoner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidityReport validate() {
        this.checkOpen();
        this.prepare();
        StandardValidityReport report = new StandardValidityReport();
        try {
            this.m_adapter.collectNamedTerms("allIndividuals", new String[]{"individualSet", "individual"});
        }
        catch (DIGInconsistentKBException e) {
            report.add(true, "DIG KB inconsistent", e.getMessage());
            return report;
        }
        catch (DIGErrorResponseException e) {
            report.add(true, "DIG KB incoherent", e.getMessage());
        }
        Profile p = this.m_adapter.getOntLanguage();
        Node nothing = p.NOTHING().asNode();
        Property equivClass = p.EQUIVALENT_CLASS();
        DIGQueryEquivalentsTranslator q = new DIGQueryEquivalentsTranslator(equivClass.getURI(), true);
        ExtendedIterator i = q.find(new TriplePattern(null, equivClass.asNode(), p.NOTHING().asNode()), this.m_adapter);
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            Node subj = t.getSubject();
            if (subj == nothing) continue;
            report.add(true, "unsatisfiable class", subj.isBlank() ? subj.getBlankNodeId().toString() : subj.getURI(), t.getSubject());
        }
        DIGQueryTypesTranslator q1 = new DIGQueryTypesTranslator(RDF.type.getURI());
        DIGValueToNodeMapper vMap = new DIGValueToNodeMapper();
        Iterator j = this.m_adapter.getKnownIndividuals().iterator();
        while (j.hasNext()) {
            String ind = (String)j.next();
            Node indNode = (Node)vMap.map1(ind);
            ClosableIterator i1 = null;
            try {
                i1 = q1.find(new TriplePattern(indNode, RDF.type.asNode(), null), this.m_adapter);
            }
            catch (DIGInconsistentKBException e) {
                report.add(true, "DIG KB inconsistent", e.getMessage());
                break;
            }
            catch (DIGErrorResponseException e) {
                report.add(true, "meaningless individual", indNode.isBlank() ? indNode.getBlankNodeId().toString() : indNode.getURI(), ind);
            }
            finally {
                if (i1 == null) continue;
                i1.close();
            }
        }
        return report;
    }
}

