/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnection;
import mx.com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryEquivalentsTranslator
extends DIGQueryTranslator {
    protected boolean m_subjectFree;

    public DIGQueryEquivalentsTranslator(String predicate, boolean subjectFree) {
        super(null, predicate, null);
        this.m_subjectFree = subjectFree;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element equivalents = da.createQueryElement(query2, "equivalents");
        da.addClassDescription(equivalents, this.m_subjectFree ? pattern.getObject() : pattern.getSubject());
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.translateConceptSetResponse(response, query2, !this.m_subjectFree, da);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return null;
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return this.m_subjectFree && !subject.isConcrete() || da.isConcept(subject, premises);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return !this.m_subjectFree && !object.isConcrete() || da.isConcept(object, premises);
    }

    public boolean checkTriple(TriplePattern pattern, DIGAdapter da, Model premises) {
        return super.checkTriple(pattern, da, premises) && (!pattern.getSubject().isConcrete() || !pattern.getObject().isConcrete());
    }
}

