/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnection;
import mx.com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;
import mx.com.hp.hpl.jena.util.iterator.SingletonIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryInstanceTranslator
extends DIGQueryTranslator {
    public DIGQueryInstanceTranslator(String predicate) {
        super(null, predicate, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element instance = da.createQueryElement(query2, "instance");
        da.addNamedElement(instance, "individual", da.getNodeID(pattern.getSubject()));
        da.addClassDescription(instance, pattern.getObject());
        return query2;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element instance = da.createQueryElement(query2, "instance");
        da.addNamedElement(instance, "individual", da.getNodeID(pattern.getSubject()));
        if (pattern.getObject().isBlank()) {
            da.addClassDescription(instance, pattern.getObject(), premises);
        } else {
            da.addClassDescription(instance, pattern.getObject());
        }
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.isFalse(response) ? NullIterator.instance : new SingletonIterator(query2.asTriple());
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return da.isConcept(object, premises);
    }
}

